/********************************
 * western_european_bitmap_31.h *
 ********************************/

/****************************************************************************
 *   Written By Marcio Teixeira 2019 - Aleph Objects, Inc.                  *
 *                                                                          *
 *   This program is free software: you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation, either version 3 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 *                                                                          *
 *   To view a copy of the GNU General Public License, go to the following  *
 *   location: <https://www.gnu.org/licenses/>.                              *
 ****************************************************************************/

#pragma once

/* This is a dump of "font_bitmaps/western_european_bitmap_31.png"
 * using the tool "bitmap2cpp.py". The tool converts the image into
 * 16-level grayscale and packs two pixels per byte. The resulting
 * bytes are then RLE compressed to yield (count, byte) pairs.
 */

const unsigned char font[] PROGMEM = {

  /* 0 GRAVE */
  0x76, 0x00, 0x01, 0x08, 0x01, 0xee, 0x01, 0xe5, 0x11, 0x00, 0x01, 0xaf,
  0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xd0,
  0x10, 0x00, 0x01, 0x01, 0x01, 0xdf, 0x01, 0xf9, 0x11, 0x00, 0x01, 0x2e,
  0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf2,
  0x11, 0x00, 0x01, 0x5f, 0x01, 0xfd, 0x11, 0x00, 0x01, 0x06, 0x01, 0x99,
  0x01, 0x40, 0xff, 0x00, 0xff, 0x00, 0xa4, 0x00,

  /* 1 ACUTE */
  0x7b, 0x00, 0x01, 0x9e, 0x01, 0xee, 0x01, 0x50, 0x0f, 0x00, 0x01, 0x05,
  0x01, 0xff, 0x01, 0xf8, 0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0xcf, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x09, 0x01, 0xff,
  0x01, 0xd1, 0x10, 0x00, 0x01, 0x4f, 0x01, 0xfe, 0x01, 0x20, 0x0f, 0x00,
  0x01, 0x01, 0x01, 0xef, 0x01, 0xf3, 0x10, 0x00, 0x01, 0x07, 0x01, 0xaa,
  0x01, 0x40, 0xff, 0x00, 0xff, 0x00, 0xa5, 0x00,

  /* 2 CIRCUMFLEX */
  0x79, 0x00, 0x01, 0xcf, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x07, 0x02, 0xff,
  0x01, 0x60, 0x0f, 0x00, 0x01, 0x2f, 0x02, 0xff, 0x01, 0xf2, 0x0f, 0x00,
  0x01, 0xcf, 0x01, 0xf6, 0x01, 0x6f, 0x01, 0xfb, 0x0e, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xa0, 0x01, 0x0a, 0x01, 0xff, 0x01, 0x60, 0x0d, 0x00,
  0x01, 0x1f, 0x01, 0xfd, 0x01, 0x00, 0x01, 0x01, 0x01, 0xdf, 0x01, 0xf1,
  0x0d, 0x00, 0x01, 0xbf, 0x01, 0xf3, 0x02, 0x00, 0x01, 0x3f, 0x01, 0xfb,
  0x0c, 0x00, 0x01, 0x02, 0x01, 0x99, 0x01, 0x50, 0x02, 0x00, 0x01, 0x05,
  0x01, 0x99, 0x01, 0x20, 0xff, 0x00, 0xff, 0x00, 0xa2, 0x00,

  /* 3 TILDE */
  0x7c, 0x00, 0x01, 0x11, 0x0d, 0x00, 0x01, 0x09, 0x01, 0xff, 0x01, 0xc3,
  0x02, 0x00, 0x01, 0xff, 0x01, 0x80, 0x0c, 0x00, 0x01, 0xaf, 0x02, 0xff,
  0x01, 0x50, 0x01, 0x01, 0x01, 0xff, 0x01, 0x60, 0x0b, 0x00, 0x01, 0x02,
  0x01, 0xff, 0x01, 0xd9, 0x01, 0xff, 0x01, 0xf7, 0x01, 0x07, 0x01, 0xff,
  0x01, 0x40, 0x0b, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0x20, 0x01, 0x3e,
  0x02, 0xff, 0x01, 0xfd, 0x0c, 0x00, 0x01, 0x09, 0x01, 0xfe, 0x01, 0x00,
  0x01, 0x02, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xf4, 0x0c, 0x00, 0x01, 0x07,
  0x01, 0xa8, 0x02, 0x00, 0x01, 0x06, 0x01, 0x98, 0x01, 0x20, 0xff, 0x00,
  0xff, 0x00, 0xb6, 0x00,

  /* 4 DIAERESIS */
  0x8a, 0x00, 0x02, 0x44, 0x02, 0x00, 0x02, 0x44, 0x0d, 0x00, 0x02, 0xff,
  0x01, 0x10, 0x01, 0x01, 0x02, 0xff, 0x0d, 0x00, 0x02, 0xff, 0x01, 0x10,
  0x01, 0x01, 0x02, 0xff, 0x0d, 0x00, 0x02, 0xff, 0x01, 0x10, 0x01, 0x01,
  0x02, 0xff, 0x0d, 0x00, 0x02, 0xcc, 0x01, 0x10, 0x01, 0x01, 0x02, 0xcc,
  0xff, 0x00, 0xff, 0x00, 0xc9, 0x00,

  /* 5 DOT_ABOVE / DEGREE_SIGN */
  0x2d, 0x00, 0x01, 0x13, 0x01, 0x30, 0x10, 0x00, 0x01, 0x2b, 0x02, 0xff,
  0x01, 0xa1, 0x0e, 0x00, 0x01, 0x02, 0x01, 0xef, 0x02, 0xff, 0x01, 0xfd,
  0x01, 0x10, 0x0d, 0x00, 0x01, 0x0d, 0x01, 0xff, 0x01, 0x94, 0x01, 0x5a,
  0x01, 0xff, 0x01, 0xb0, 0x0d, 0x00, 0x01, 0x4f, 0x01, 0xf7, 0x02, 0x00,
  0x01, 0x9f, 0x01, 0xf2, 0x0d, 0x00, 0x01, 0x8f, 0x01, 0xf0, 0x02, 0x00,
  0x01, 0x2f, 0x01, 0xf6, 0x0d, 0x00, 0x01, 0x8f, 0x01, 0xe0, 0x02, 0x00,
  0x01, 0x0f, 0x01, 0xf7, 0x0d, 0x00, 0x01, 0x7f, 0x01, 0xf2, 0x02, 0x00,
  0x01, 0x4f, 0x01, 0xf5, 0x0d, 0x00, 0x01, 0x2f, 0x01, 0xfc, 0x01, 0x10,
  0x01, 0x02, 0x01, 0xdf, 0x01, 0xf0, 0x0d, 0x00, 0x01, 0x08, 0x01, 0xff,
  0x01, 0xfb, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x60, 0x0e, 0x00, 0x01, 0x9f,
  0x02, 0xff, 0x01, 0xf8, 0x0f, 0x00, 0x01, 0x03, 0x01, 0x9c, 0x01, 0xc9,
  0x01, 0x30, 0xff, 0x00, 0xff, 0x00, 0xa4, 0x00,

  /* 6 CEDILLA */
  0xff, 0x00, 0xff, 0x00, 0xee, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0x20,
  0x11, 0x00, 0x01, 0xcf, 0x01, 0xc0, 0x11, 0x00, 0x01, 0x3f, 0x01, 0xf6,
  0x11, 0x00, 0x01, 0x0f, 0x01, 0xfb, 0x11, 0x00, 0x01, 0x3f, 0x01, 0xfd,
  0x0e, 0x00, 0x01, 0x07, 0x01, 0xd9, 0x01, 0x89, 0x01, 0xff, 0x01, 0xfb,
  0x0e, 0x00, 0x01, 0x07, 0x03, 0xff, 0x01, 0xf3, 0x0e, 0x00, 0x01, 0x04,
  0x01, 0xbd, 0x01, 0xee, 0x01, 0xd9, 0x01, 0x20, 0x2f, 0x00,

  /* 7 NO_DOT_I */
  0xff, 0x00, 0x32, 0x00, 0x01, 0x01, 0x01, 0x99, 0x01, 0x96, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xf9, 0x10, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0x10, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf9, 0xcd, 0x00,

#if ENABLED(TOUCH_UI_UTF8_GERMANIC)
  /* 8 SHARP_S */
  0x8a, 0x00, 0x01, 0x35, 0x01, 0x66, 0x01, 0x52, 0x0e, 0x00, 0x01, 0x03,
  0x01, 0xaf, 0x03, 0xff, 0x01, 0xe7, 0x0d, 0x00, 0x01, 0x7f, 0x05, 0xff,
  0x01, 0xc1, 0x0b, 0x00, 0x01, 0x07, 0x02, 0xff, 0x01, 0xfc, 0x01, 0xaa,
  0x01, 0xdf, 0x01, 0xff, 0x01, 0xfc, 0x0b, 0x00, 0x01, 0x2f, 0x01, 0xff,
  0x01, 0xf9, 0x01, 0x10, 0x01, 0x00, 0x01, 0x02, 0x01, 0xcf, 0x01, 0xff,
  0x01, 0x70, 0x0a, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0x80, 0x03, 0x00,
  0x01, 0x0d, 0x01, 0xff, 0x01, 0xe0, 0x0a, 0x00, 0x01, 0xef, 0x01, 0xff,
  0x04, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xf3, 0x09, 0x00, 0x01, 0x02,
  0x01, 0xff, 0x01, 0xfb, 0x04, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf7,
  0x09, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf9, 0x03, 0x00, 0x01, 0x03,
  0x01, 0x9e, 0x01, 0xff, 0x01, 0xf8, 0x09, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf8, 0x02, 0x00, 0x01, 0x01, 0x01, 0xaf, 0x02, 0xff, 0x01, 0xd7,
  0x09, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x02, 0x00, 0x01, 0x1d,
  0x01, 0xff, 0x01, 0xfc, 0x01, 0x50, 0x0a, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf8, 0x02, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0x70, 0x0b, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x01, 0x00, 0x01, 0x01, 0x01, 0xff,
  0x01, 0xfa, 0x0c, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x01, 0x00,
  0x01, 0x05, 0x01, 0xff, 0x01, 0xf4, 0x0c, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf8, 0x01, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf4, 0x0c, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x01, 0x00, 0x01, 0x05, 0x01, 0xff,
  0x01, 0xf9, 0x0c, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x01, 0x00,
  0x01, 0x02, 0x02, 0xff, 0x01, 0x50, 0x0b, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf8, 0x02, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0xf8, 0x0b, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x02, 0x00, 0x01, 0x1d, 0x02, 0xff,
  0x01, 0xd3, 0x0a, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x02, 0x00,
  0x01, 0x01, 0x01, 0xcf, 0x02, 0xff, 0x01, 0x70, 0x09, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf8, 0x03, 0x00, 0x01, 0x07, 0x02, 0xff, 0x01, 0xfb,
  0x09, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x04, 0x00, 0x01, 0x2b,
  0x02, 0xff, 0x01, 0xb0, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8,
  0x05, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0xf6, 0x08, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf8, 0x05, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xfd,
  0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x06, 0x00, 0x01, 0xdf,
  0x01, 0xff, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xff, 0x01, 0x10, 0x07, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf8, 0x06, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x08, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf8, 0x05, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xfd,
  0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x01, 0x02, 0x01, 0x84,
  0x03, 0x00, 0x01, 0x2d, 0x01, 0xff, 0x01, 0xf8, 0x08, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf8, 0x01, 0x02, 0x01, 0xff, 0x01, 0xec, 0x01, 0xa9,
  0x01, 0xac, 0x02, 0xff, 0x01, 0xe0, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf8, 0x01, 0x02, 0x05, 0xff, 0x01, 0xfe, 0x01, 0x20, 0x08, 0x00,
  0x01, 0x03, 0x01, 0xee, 0x01, 0xe7, 0x01, 0x01, 0x01, 0xbf, 0x03, 0xff,
  0x01, 0xfe, 0x01, 0x80, 0x0e, 0x00, 0x01, 0x35, 0x01, 0x78, 0x01, 0x76,
  0x01, 0x30, 0xb4, 0x00,
#endif

#if ENABLED(TOUCH_UI_UTF8_SCANDINAVIAN)
  /* 9 LRG_O_STROKE */
  0x93, 0x00, 0x01, 0x40, 0x0a, 0x00, 0x01, 0x47, 0x01, 0x9a, 0x01, 0xba,
  0x01, 0x95, 0x01, 0x10, 0x02, 0x00, 0x01, 0x07, 0x01, 0xf8, 0x08, 0x00,
  0x01, 0x02, 0x01, 0xaf, 0x04, 0xff, 0x01, 0xfc, 0x01, 0x50, 0x01, 0x00,
  0x01, 0x5f, 0x01, 0xff, 0x01, 0x30, 0x07, 0x00, 0x01, 0x8f, 0x06, 0xff,
  0x01, 0xfc, 0x01, 0x23, 0x01, 0xff, 0x01, 0xf6, 0x07, 0x00, 0x01, 0x1c,
  0x03, 0xff, 0x01, 0xca, 0x01, 0x9b, 0x01, 0xdf, 0x02, 0xff, 0x01, 0xfe,
  0x01, 0xff, 0x01, 0x80, 0x07, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0xfd,
  0x01, 0x50, 0x02, 0x00, 0x01, 0x02, 0x01, 0x9f, 0x02, 0xff, 0x01, 0xfa,
  0x07, 0x00, 0x01, 0x09, 0x02, 0xff, 0x01, 0x90, 0x04, 0x00, 0x01, 0x03,
  0x01, 0xef, 0x01, 0xff, 0x01, 0xf3, 0x07, 0x00, 0x01, 0x5f, 0x01, 0xff,
  0x01, 0xf9, 0x06, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0xfc, 0x07, 0x00,
  0x01, 0xdf, 0x01, 0xff, 0x01, 0xc0, 0x05, 0x00, 0x01, 0x06, 0x03, 0xff,
  0x01, 0x60, 0x05, 0x00, 0x01, 0x04, 0x02, 0xff, 0x01, 0x30, 0x05, 0x00,
  0x01, 0x4f, 0x01, 0xff, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xc0, 0x05, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0xfc, 0x05, 0x00, 0x01, 0x02, 0x01, 0xef,
  0x01, 0xf7, 0x01, 0x3f, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00, 0x01, 0x0f,
  0x01, 0xff, 0x01, 0xf6, 0x05, 0x00, 0x01, 0x1d, 0x01, 0xff, 0x01, 0xa0,
  0x01, 0x0d, 0x01, 0xff, 0x01, 0xf8, 0x05, 0x00, 0x01, 0x3f, 0x01, 0xff,
  0x01, 0xf2, 0x05, 0x00, 0x01, 0xcf, 0x01, 0xfc, 0x01, 0x00, 0x01, 0x09,
  0x01, 0xff, 0x01, 0xfb, 0x05, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0xe0,
  0x04, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xd1, 0x01, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xfe, 0x05, 0x00, 0x01, 0x8f, 0x01, 0xff, 0x01, 0xc0,
  0x04, 0x00, 0x01, 0x7f, 0x01, 0xff, 0x01, 0x20, 0x01, 0x00, 0x01, 0x03,
  0x02, 0xff, 0x05, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0xb0, 0x03, 0x00,
  0x01, 0x05, 0x01, 0xff, 0x01, 0xf4, 0x02, 0x00, 0x01, 0x02, 0x02, 0xff,
  0x01, 0x10, 0x04, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xa0, 0x03, 0x00,
  0x01, 0x3f, 0x01, 0xff, 0x01, 0x60, 0x02, 0x00, 0x01, 0x01, 0x02, 0xff,
  0x01, 0x30, 0x04, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xa0, 0x02, 0x00,
  0x01, 0x01, 0x01, 0xef, 0x01, 0xf8, 0x03, 0x00, 0x01, 0x02, 0x02, 0xff,
  0x01, 0x20, 0x04, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0xb0, 0x02, 0x00,
  0x01, 0x0d, 0x01, 0xff, 0x01, 0xb0, 0x03, 0x00, 0x01, 0x03, 0x02, 0xff,
  0x01, 0x10, 0x04, 0x00, 0x01, 0x8f, 0x01, 0xff, 0x01, 0xc0, 0x02, 0x00,
  0x01, 0xbf, 0x01, 0xfd, 0x04, 0x00, 0x01, 0x04, 0x02, 0xff, 0x05, 0x00,
  0x01, 0x6f, 0x01, 0xff, 0x01, 0xe0, 0x01, 0x00, 0x01, 0x08, 0x01, 0xff,
  0x01, 0xe1, 0x04, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xfe, 0x05, 0x00,
  0x01, 0x2f, 0x01, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x6f, 0x01, 0xff,
  0x01, 0x30, 0x04, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xfa, 0x05, 0x00,
  0x01, 0x0f, 0x01, 0xff, 0x01, 0xf6, 0x01, 0x04, 0x01, 0xff, 0x01, 0xf5,
  0x05, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf7, 0x05, 0x00, 0x01, 0x09,
  0x01, 0xff, 0x01, 0xfc, 0x01, 0x2e, 0x01, 0xff, 0x01, 0x70, 0x05, 0x00,
  0x01, 0x5f, 0x01, 0xff, 0x01, 0xf2, 0x05, 0x00, 0x01, 0x03, 0x02, 0xff,
  0x01, 0xef, 0x01, 0xfa, 0x06, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0xb0,
  0x06, 0x00, 0x01, 0xcf, 0x02, 0xff, 0x01, 0xc0, 0x05, 0x00, 0x01, 0x06,
  0x02, 0xff, 0x01, 0x40, 0x06, 0x00, 0x01, 0x2f, 0x02, 0xff, 0x01, 0x20,
  0x05, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xfb, 0x07, 0x00, 0x01, 0x0b,
  0x02, 0xff, 0x01, 0xd2, 0x04, 0x00, 0x01, 0x06, 0x02, 0xff, 0x01, 0xe1,
  0x07, 0x00, 0x01, 0x5f, 0x03, 0xff, 0x01, 0x93, 0x02, 0x00, 0x01, 0x05,
  0x01, 0xcf, 0x02, 0xff, 0x01, 0x30, 0x06, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xfb, 0x03, 0xff, 0x01, 0xfd, 0x01, 0xde, 0x03, 0xff, 0x01, 0xe3,
  0x07, 0x00, 0x01, 0x1e, 0x01, 0xff, 0x01, 0x80, 0x01, 0x4d, 0x06, 0xff,
  0x01, 0xfa, 0x01, 0x10, 0x07, 0x00, 0x01, 0xbf, 0x01, 0xfb, 0x02, 0x00,
  0x01, 0x5c, 0x04, 0xff, 0x01, 0xe9, 0x01, 0x30, 0x08, 0x00, 0x01, 0x1c,
  0x01, 0xd0, 0x03, 0x00, 0x01, 0x04, 0x01, 0x67, 0x01, 0x86, 0x01, 0x53,
  0x0b, 0x00, 0x01, 0x10, 0xa8, 0x00,

  /* 10 SML_O_STROKE */
  0xff, 0x00, 0x15, 0x00, 0x01, 0x02, 0x01, 0x20, 0x0c, 0x00, 0x01, 0x02,
  0x01, 0x32, 0x01, 0x10, 0x02, 0x00, 0x01, 0x1d, 0x01, 0xe3, 0x0a, 0x00,
  0x01, 0x01, 0x01, 0x7c, 0x02, 0xff, 0x01, 0xfd, 0x01, 0x82, 0x01, 0x00,
  0x01, 0xcf, 0x01, 0xf7, 0x0a, 0x00, 0x01, 0x6e, 0x05, 0xff, 0x01, 0x89,
  0x01, 0xff, 0x01, 0xa0, 0x09, 0x00, 0x01, 0x08, 0x07, 0xff, 0x01, 0xfc,
  0x0a, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0xfc, 0x01, 0x50, 0x01, 0x00,
  0x01, 0x3a, 0x02, 0xff, 0x01, 0xf1, 0x09, 0x00, 0x01, 0x01, 0x02, 0xff,
  0x01, 0x90, 0x03, 0x00, 0x01, 0x7f, 0x01, 0xff, 0x01, 0xf5, 0x09, 0x00,
  0x01, 0x08, 0x01, 0xff, 0x01, 0xfc, 0x03, 0x00, 0x01, 0x01, 0x01, 0xdf,
  0x01, 0xff, 0x01, 0xfd, 0x09, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf3,
  0x03, 0x00, 0x01, 0x0b, 0x03, 0xff, 0x01, 0x30, 0x08, 0x00, 0x01, 0x3f,
  0x01, 0xff, 0x01, 0xd0, 0x03, 0x00, 0x01, 0x9f, 0x01, 0xfa, 0x01, 0x8f,
  0x01, 0xff, 0x01, 0x80, 0x08, 0x00, 0x01, 0x7f, 0x01, 0xff, 0x01, 0x80,
  0x02, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xc0, 0x01, 0x3f, 0x01, 0xff,
  0x01, 0xb0, 0x08, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0x50, 0x02, 0x00,
  0x01, 0x3f, 0x01, 0xfe, 0x01, 0x10, 0x01, 0x1f, 0x01, 0xff, 0x01, 0xe0,
  0x08, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0x40, 0x01, 0x00, 0x01, 0x02,
  0x01, 0xef, 0x01, 0xf3, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xf0,
  0x08, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x30, 0x01, 0x00, 0x01, 0x0d,
  0x01, 0xff, 0x01, 0x50, 0x01, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf0,
  0x08, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0x30, 0x01, 0x00, 0x01, 0xbf,
  0x01, 0xf8, 0x02, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xf0, 0x08, 0x00,
  0x01, 0x9f, 0x01, 0xff, 0x01, 0x40, 0x01, 0x08, 0x01, 0xff, 0x01, 0xb0,
  0x02, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xe0, 0x08, 0x00, 0x01, 0x7f,
  0x01, 0xff, 0x01, 0x60, 0x01, 0x5f, 0x01, 0xfd, 0x03, 0x00, 0x01, 0x3f,
  0x01, 0xff, 0x01, 0xc0, 0x08, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xa3,
  0x01, 0xff, 0x01, 0xe2, 0x03, 0x00, 0x01, 0x7f, 0x01, 0xff, 0x01, 0x90,
  0x08, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xfe, 0x01, 0xff, 0x01, 0x40,
  0x03, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x08, 0x00, 0x01, 0x0a,
  0x02, 0xff, 0x01, 0xf6, 0x03, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xfe,
  0x09, 0x00, 0x01, 0x02, 0x02, 0xff, 0x01, 0xb0, 0x03, 0x00, 0x01, 0x2e,
  0x01, 0xff, 0x01, 0xf8, 0x0a, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0xf7,
  0x02, 0x00, 0x01, 0x05, 0x01, 0xef, 0x01, 0xff, 0x01, 0xd0, 0x09, 0x00,
  0x01, 0x04, 0x03, 0xff, 0x01, 0xfc, 0x01, 0xab, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xfe, 0x01, 0x20, 0x09, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0xaf,
  0x05, 0xff, 0x01, 0xd2, 0x09, 0x00, 0x01, 0x01, 0x01, 0xdf, 0x01, 0xf5,
  0x01, 0x04, 0x01, 0xbf, 0x03, 0xff, 0x01, 0xd6, 0x0a, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0x70, 0x01, 0x00, 0x01, 0x01, 0x01, 0x46, 0x01, 0x76,
  0x01, 0x52, 0x0c, 0x00, 0x01, 0x28, 0xa9, 0x00,

  /* 11 LRG_AE */
  0x9e, 0x00, 0x01, 0x14, 0x0b, 0x44, 0x01, 0x41, 0x06, 0x00, 0x01, 0x8f,
  0x0b, 0xff, 0x01, 0xf3, 0x06, 0x00, 0x01, 0xef, 0x0b, 0xff, 0x01, 0xf3,
  0x05, 0x00, 0x01, 0x05, 0x02, 0xff, 0x01, 0xee, 0x09, 0xff, 0x01, 0xf3,
  0x05, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xf5, 0x01, 0x00, 0x01, 0xdf,
  0x01, 0xff, 0x01, 0x63, 0x06, 0x33, 0x01, 0x30, 0x05, 0x00, 0x01, 0x3f,
  0x01, 0xff, 0x01, 0xe0, 0x01, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40,
  0x0c, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0x80, 0x01, 0x00, 0x01, 0xdf,
  0x01, 0xff, 0x01, 0x40, 0x0b, 0x00, 0x01, 0x01, 0x02, 0xff, 0x01, 0x10,
  0x01, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40, 0x0b, 0x00, 0x01, 0x07,
  0x01, 0xff, 0x01, 0xfa, 0x02, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40,
  0x0b, 0x00, 0x01, 0x0d, 0x01, 0xff, 0x01, 0xf3, 0x02, 0x00, 0x01, 0xdf,
  0x01, 0xff, 0x01, 0x40, 0x0b, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xd0,
  0x02, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40, 0x0b, 0x00, 0x01, 0xbf,
  0x01, 0xff, 0x01, 0x60, 0x02, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40,
  0x0a, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xfe, 0x03, 0x00, 0x01, 0xdf,
  0x01, 0xff, 0x01, 0x40, 0x0a, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xf9,
  0x03, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xed, 0x06, 0xdd, 0x01, 0x80,
  0x03, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf2, 0x03, 0x00, 0x01, 0xdf,
  0x08, 0xff, 0x01, 0xa0, 0x03, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0xb0,
  0x03, 0x00, 0x01, 0xdf, 0x08, 0xff, 0x01, 0xa0, 0x03, 0x00, 0x01, 0xcf,
  0x01, 0xff, 0x01, 0x40, 0x03, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xa8,
  0x06, 0x88, 0x01, 0x50, 0x02, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xfe,
  0x04, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40, 0x09, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xf7, 0x04, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40,
  0x09, 0x00, 0x01, 0x1f, 0x01, 0xff, 0x01, 0xf4, 0x04, 0x33, 0x01, 0xdf,
  0x01, 0xff, 0x01, 0x40, 0x09, 0x00, 0x01, 0x7f, 0x08, 0xff, 0x01, 0x40,
  0x09, 0x00, 0x01, 0xef, 0x08, 0xff, 0x01, 0x40, 0x08, 0x00, 0x01, 0x05,
  0x09, 0xff, 0x01, 0x40, 0x08, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0xf7,
  0x05, 0x33, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40, 0x08, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0xe0, 0x05, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x40,
  0x08, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0x80, 0x05, 0x00, 0x01, 0xdf,
  0x01, 0xff, 0x01, 0x40, 0x08, 0x00, 0x02, 0xff, 0x01, 0x20, 0x05, 0x00,
  0x01, 0xdf, 0x01, 0xff, 0x01, 0x40, 0x07, 0x00, 0x01, 0x06, 0x01, 0xff,
  0x01, 0xfb, 0x06, 0x00, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xa8, 0x06, 0x88,
  0x01, 0x85, 0x01, 0x0d, 0x01, 0xff, 0x01, 0xf4, 0x06, 0x00, 0x01, 0xdf,
  0x08, 0xff, 0x01, 0xf9, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xe0, 0x06, 0x00,
  0x01, 0xdf, 0x08, 0xff, 0x01, 0xf9, 0x01, 0x8d, 0x01, 0xdd, 0x01, 0x60,
  0x06, 0x00, 0x01, 0xbd, 0x08, 0xdd, 0x01, 0xd8, 0xbe, 0x00,

  /* 12 SML_AE */
  0xff, 0x00, 0x22, 0x00, 0x01, 0x01, 0x01, 0x34, 0x01, 0x31, 0x06, 0x00,
  0x01, 0x12, 0x01, 0x42, 0x01, 0x10, 0x05, 0x00, 0x01, 0x02, 0x01, 0x7b,
  0x01, 0xef, 0x02, 0xff, 0x01, 0xfb, 0x01, 0x60, 0x02, 0x00, 0x01, 0x03,
  0x01, 0x9e, 0x02, 0xff, 0x01, 0xfd, 0x01, 0x81, 0x04, 0x00, 0x01, 0xbf,
  0x05, 0xff, 0x01, 0xfe, 0x01, 0x40, 0x01, 0x01, 0x01, 0x9f, 0x05, 0xff,
  0x01, 0x60, 0x03, 0x00, 0x01, 0xdf, 0x02, 0xff, 0x01, 0xee, 0x03, 0xff,
  0x01, 0xf5, 0x01, 0x1d, 0x03, 0xff, 0x01, 0xef, 0x02, 0xff, 0x01, 0xf8,
  0x03, 0x00, 0x01, 0xdf, 0x01, 0xb6, 0x01, 0x30, 0x01, 0x00, 0x01, 0x01,
  0x01, 0x5d, 0x02, 0xff, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xe7, 0x01, 0x20,
  0x01, 0x00, 0x01, 0x29, 0x02, 0xff, 0x01, 0x50, 0x02, 0x00, 0x01, 0x71,
  0x05, 0x00, 0x01, 0xaf, 0x02, 0xff, 0x01, 0xfb, 0x01, 0x10, 0x03, 0x00,
  0x01, 0x4f, 0x01, 0xff, 0x01, 0xe0, 0x08, 0x00, 0x01, 0x0d, 0x02, 0xff,
  0x01, 0xd0, 0x04, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf7, 0x08, 0x00,
  0x01, 0x06, 0x02, 0xff, 0x01, 0x40, 0x05, 0x00, 0x01, 0xef, 0x01, 0xfd,
  0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xfd, 0x06, 0x00, 0x01, 0x9f,
  0x01, 0xff, 0x04, 0x00, 0x01, 0x02, 0x01, 0x45, 0x02, 0x66, 0x01, 0x67,
  0x01, 0xff, 0x01, 0xf9, 0x06, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x03, 0x00,
  0x01, 0x4a, 0x06, 0xff, 0x01, 0xfb, 0x03, 0x66, 0x01, 0x67, 0x02, 0x77,
  0x01, 0xaf, 0x01, 0xff, 0x02, 0x00, 0x01, 0x1b, 0x10, 0xff, 0x01, 0x00,
  0x01, 0x01, 0x01, 0xdf, 0x02, 0xff, 0x01, 0xca, 0x01, 0x98, 0x01, 0x88,
  0x01, 0x89, 0x0a, 0xff, 0x01, 0x00, 0x01, 0x09, 0x01, 0xff, 0x01, 0xfd,
  0x01, 0x40, 0x03, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xfa, 0x08, 0x77,
  0x01, 0x00, 0x01, 0x1f, 0x01, 0xff, 0x01, 0xd0, 0x04, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf7, 0x09, 0x00, 0x01, 0x5f, 0x01, 0xff, 0x01, 0x70,
  0x04, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xfa, 0x09, 0x00, 0x01, 0x7f,
  0x01, 0xff, 0x01, 0x30, 0x04, 0x00, 0x01, 0x09, 0x01, 0xff, 0x01, 0xfe,
  0x09, 0x00, 0x01, 0x7f, 0x01, 0xff, 0x01, 0x30, 0x04, 0x00, 0x01, 0x0f,
  0x02, 0xff, 0x01, 0x50, 0x08, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0x60,
  0x04, 0x00, 0x01, 0x8f, 0x02, 0xff, 0x01, 0xe1, 0x08, 0x00, 0x01, 0x3f,
  0x01, 0xff, 0x01, 0xd0, 0x03, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xfe,
  0x01, 0xff, 0x01, 0xfc, 0x01, 0x10, 0x05, 0x00, 0x01, 0x45, 0x01, 0x00,
  0x01, 0x0d, 0x01, 0xff, 0x01, 0xfc, 0x01, 0x20, 0x01, 0x00, 0x01, 0x01,
  0x01, 0x9f, 0x01, 0xff, 0x01, 0xa2, 0x02, 0xff, 0x01, 0xe6, 0x01, 0x10,
  0x02, 0x00, 0x01, 0x02, 0x01, 0x8d, 0x01, 0xf8, 0x01, 0x00, 0x01, 0x05,
  0x02, 0xff, 0x01, 0xfd, 0x01, 0xab, 0x01, 0xcf, 0x01, 0xff, 0x01, 0xfc,
  0x01, 0x00, 0x01, 0x3f, 0x02, 0xff, 0x01, 0xfd, 0x01, 0xba, 0x01, 0xbc,
  0x02, 0xff, 0x01, 0xf8, 0x02, 0x00, 0x01, 0x7f, 0x05, 0xff, 0x01, 0xa0,
  0x01, 0x00, 0x01, 0x02, 0x01, 0xcf, 0x06, 0xff, 0x01, 0xf7, 0x02, 0x00,
  0x01, 0x03, 0x01, 0xbf, 0x03, 0xff, 0x01, 0xb4, 0x03, 0x00, 0x01, 0x05,
  0x01, 0xbf, 0x04, 0xff, 0x01, 0xb7, 0x01, 0x10, 0x03, 0x00, 0x01, 0x01,
  0x01, 0x46, 0x01, 0x76, 0x01, 0x41, 0x06, 0x00, 0x01, 0x35, 0x01, 0x67,
  0x01, 0x64, 0x01, 0x20, 0xad, 0x00,

  /* 13 LRG_ETH */
  0x9a, 0x00, 0x01, 0x34, 0x03, 0x44, 0x01, 0x43, 0x01, 0x21, 0x0d, 0x00,
  0x01, 0xbf, 0x05, 0xff, 0x01, 0xfe, 0x01, 0xb8, 0x01, 0x40, 0x0a, 0x00,
  0x01, 0xbf, 0x07, 0xff, 0x01, 0xfe, 0x01, 0x81, 0x09, 0x00, 0x01, 0xbf,
  0x08, 0xff, 0x01, 0xfe, 0x01, 0x60, 0x08, 0x00, 0x01, 0xbf, 0x01, 0xff,
  0x01, 0x61, 0x02, 0x11, 0x01, 0x23, 0x01, 0x58, 0x01, 0xcf, 0x02, 0xff,
  0x01, 0xf9, 0x08, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x04, 0x00,
  0x01, 0x02, 0x01, 0x9f, 0x02, 0xff, 0x01, 0x80, 0x07, 0x00, 0x01, 0xbf,
  0x01, 0xff, 0x01, 0x50, 0x05, 0x00, 0x01, 0x04, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xf4, 0x07, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x06, 0x00,
  0x01, 0x2f, 0x01, 0xff, 0x01, 0xfd, 0x07, 0x00, 0x01, 0xbf, 0x01, 0xff,
  0x01, 0x50, 0x06, 0x00, 0x01, 0x06, 0x02, 0xff, 0x01, 0x50, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x07, 0x00, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xb0, 0x06, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x07, 0x00,
  0x01, 0x7f, 0x01, 0xff, 0x01, 0xf0, 0x06, 0x00, 0x01, 0xbf, 0x01, 0xff,
  0x01, 0x50, 0x07, 0x00, 0x01, 0x3f, 0x01, 0xff, 0x01, 0xf3, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x07, 0x00, 0x01, 0x0f, 0x01, 0xff,
  0x01, 0xf5, 0x04, 0x00, 0x01, 0x23, 0x01, 0x33, 0x01, 0xcf, 0x01, 0xff,
  0x01, 0x73, 0x02, 0x33, 0x01, 0x30, 0x04, 0x00, 0x01, 0x0d, 0x01, 0xff,
  0x01, 0xf6, 0x04, 0x00, 0x01, 0xcf, 0x06, 0xff, 0x01, 0xf2, 0x04, 0x00,
  0x01, 0x0c, 0x01, 0xff, 0x01, 0xf7, 0x04, 0x00, 0x01, 0xcf, 0x06, 0xff,
  0x01, 0xf2, 0x04, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0xf9, 0x04, 0x00,
  0x01, 0x9b, 0x01, 0xbb, 0x01, 0xef, 0x01, 0xff, 0x01, 0xdb, 0x02, 0xbb,
  0x01, 0xb1, 0x04, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xf8, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x07, 0x00, 0x01, 0x0d, 0x01, 0xff,
  0x01, 0xf7, 0x06, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x07, 0x00,
  0x01, 0x0e, 0x01, 0xff, 0x01, 0xf6, 0x06, 0x00, 0x01, 0xbf, 0x01, 0xff,
  0x01, 0x50, 0x07, 0x00, 0x01, 0x1f, 0x01, 0xff, 0x01, 0xf4, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x07, 0x00, 0x01, 0x5f, 0x01, 0xff,
  0x01, 0xf1, 0x06, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x07, 0x00,
  0x01, 0xaf, 0x01, 0xff, 0x01, 0xd0, 0x06, 0x00, 0x01, 0xbf, 0x01, 0xff,
  0x01, 0x50, 0x06, 0x00, 0x01, 0x01, 0x02, 0xff, 0x01, 0x80, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x06, 0x00, 0x01, 0x0b, 0x02, 0xff,
  0x01, 0x20, 0x06, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x06, 0x00,
  0x01, 0x8f, 0x01, 0xff, 0x01, 0xf9, 0x07, 0x00, 0x01, 0xbf, 0x01, 0xff,
  0x01, 0x50, 0x05, 0x00, 0x01, 0x0a, 0x02, 0xff, 0x01, 0xe1, 0x07, 0x00,
  0x01, 0xbf, 0x01, 0xff, 0x01, 0x50, 0x04, 0x00, 0x01, 0x29, 0x03, 0xff,
  0x01, 0x30, 0x07, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0xa7, 0x01, 0x77,
  0x01, 0x78, 0x01, 0x9a, 0x01, 0xbf, 0x03, 0xff, 0x01, 0xe3, 0x08, 0x00,
  0x01, 0xbf, 0x08, 0xff, 0x01, 0xf9, 0x01, 0x10, 0x08, 0x00, 0x01, 0xbf,
  0x07, 0xff, 0x01, 0xd8, 0x01, 0x10, 0x09, 0x00, 0x01, 0xad, 0x03, 0xdd,
  0x01, 0xdc, 0x01, 0xcb, 0x01, 0xa7, 0x01, 0x41, 0xc7, 0x00,

  /* 14 SML_ETH */
  0x88, 0x00, 0x01, 0x38, 0x01, 0x88, 0x01, 0x81, 0x10, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0xfc, 0x03, 0x00, 0x01, 0x5a, 0x01, 0x40, 0x0c, 0x00,
  0x01, 0xdf, 0x01, 0xff, 0x01, 0xb0, 0x01, 0x04, 0x01, 0xaf, 0x01, 0xff,
  0x01, 0xa0, 0x0c, 0x00, 0x01, 0x1e, 0x01, 0xff, 0x01, 0xfc, 0x02, 0xff,
  0x01, 0xd8, 0x01, 0x20, 0x0c, 0x00, 0x01, 0x07, 0x02, 0xff, 0x01, 0xfd,
  0x01, 0x82, 0x0d, 0x00, 0x01, 0x5a, 0x03, 0xff, 0x01, 0xf4, 0x0d, 0x00,
  0x01, 0x7f, 0x01, 0xff, 0x01, 0xfd, 0x01, 0x87, 0x02, 0xff, 0x01, 0x30,
  0x0c, 0x00, 0x01, 0x6f, 0x01, 0xe9, 0x01, 0x30, 0x01, 0x00, 0x01, 0x8f,
  0x01, 0xff, 0x01, 0xe2, 0x0c, 0x00, 0x01, 0x03, 0x03, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xfd, 0x01, 0x10, 0x0e, 0x00, 0x01, 0x23, 0x01, 0x44,
  0x01, 0xdf, 0x01, 0xff, 0x01, 0xb0, 0x0c, 0x00, 0x01, 0x02, 0x01, 0x9e,
  0x04, 0xff, 0x01, 0xf7, 0x0c, 0x00, 0x01, 0x7f, 0x06, 0xff, 0x01, 0x30,
  0x0a, 0x00, 0x01, 0x09, 0x02, 0xff, 0x01, 0xfe, 0x01, 0xcb, 0x01, 0xdf,
  0x02, 0xff, 0x01, 0xd0, 0x0a, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0xfb,
  0x01, 0x30, 0x02, 0x00, 0x01, 0x4e, 0x01, 0xff, 0x01, 0xf5, 0x09, 0x00,
  0x01, 0x02, 0x02, 0xff, 0x01, 0x70, 0x03, 0x00, 0x01, 0x05, 0x01, 0xff,
  0x01, 0xfd, 0x09, 0x00, 0x01, 0x09, 0x01, 0xff, 0x01, 0xfa, 0x05, 0x00,
  0x01, 0xef, 0x01, 0xff, 0x01, 0x20, 0x08, 0x00, 0x01, 0x0f, 0x01, 0xff,
  0x01, 0xf1, 0x05, 0x00, 0x01, 0x8f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00,
  0x01, 0x4f, 0x01, 0xff, 0x01, 0xa0, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff,
  0x01, 0xb0, 0x08, 0x00, 0x01, 0x8f, 0x01, 0xff, 0x01, 0x70, 0x05, 0x00,
  0x01, 0x1f, 0x01, 0xff, 0x01, 0xd0, 0x08, 0x00, 0x01, 0x9f, 0x01, 0xff,
  0x01, 0x40, 0x05, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xf0, 0x08, 0x00,
  0x01, 0xaf, 0x01, 0xff, 0x01, 0x30, 0x05, 0x00, 0x01, 0x0e, 0x01, 0xff,
  0x01, 0xf0, 0x08, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0x30, 0x05, 0x00,
  0x01, 0x0f, 0x01, 0xff, 0x01, 0xf0, 0x08, 0x00, 0x01, 0x9f, 0x01, 0xff,
  0x01, 0x40, 0x05, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xe0, 0x08, 0x00,
  0x01, 0x8f, 0x01, 0xff, 0x01, 0x70, 0x05, 0x00, 0x01, 0x2f, 0x01, 0xff,
  0x01, 0xd0, 0x08, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xa0, 0x05, 0x00,
  0x01, 0x6f, 0x01, 0xff, 0x01, 0x90, 0x08, 0x00, 0x01, 0x0f, 0x01, 0xff,
  0x01, 0xf1, 0x05, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x08, 0x00,
  0x01, 0x09, 0x01, 0xff, 0x01, 0xf9, 0x04, 0x00, 0x01, 0x05, 0x01, 0xff,
  0x01, 0xfe, 0x09, 0x00, 0x01, 0x02, 0x02, 0xff, 0x01, 0x60, 0x03, 0x00,
  0x01, 0x3e, 0x01, 0xff, 0x01, 0xf6, 0x0a, 0x00, 0x01, 0x7f, 0x01, 0xff,
  0x01, 0xf9, 0x01, 0x20, 0x01, 0x00, 0x01, 0x07, 0x02, 0xff, 0x01, 0xb0,
  0x0a, 0x00, 0x01, 0x09, 0x02, 0xff, 0x01, 0xfd, 0x01, 0xbd, 0x02, 0xff,
  0x01, 0xfd, 0x01, 0x10, 0x0b, 0x00, 0x01, 0x7f, 0x05, 0xff, 0x01, 0xb0,
  0x0c, 0x00, 0x01, 0x02, 0x01, 0xae, 0x03, 0xff, 0x01, 0xb4, 0x0f, 0x00,
  0x01, 0x35, 0x01, 0x65, 0x01, 0x40, 0xb6, 0x00,

  /* 15 LRG_THORN */
  0x9a, 0x00, 0x02, 0x55, 0x11, 0x00, 0x02, 0xff, 0x01, 0x20, 0x10, 0x00,
  0x02, 0xff, 0x01, 0x20, 0x10, 0x00, 0x02, 0xff, 0x01, 0x20, 0x10, 0x00,
  0x02, 0xff, 0x01, 0x20, 0x10, 0x00, 0x02, 0xff, 0x01, 0x20, 0x10, 0x00,
  0x05, 0xff, 0x01, 0xed, 0x01, 0xa7, 0x01, 0x10, 0x0b, 0x00, 0x07, 0xff,
  0x01, 0xfa, 0x01, 0x10, 0x0a, 0x00, 0x08, 0xff, 0x01, 0xe2, 0x0a, 0x00,
  0x02, 0xff, 0x01, 0x65, 0x01, 0x55, 0x01, 0x56, 0x01, 0x7a, 0x02, 0xff,
  0x01, 0xfe, 0x01, 0x10, 0x09, 0x00, 0x02, 0xff, 0x01, 0x20, 0x03, 0x00,
  0x01, 0x1b, 0x02, 0xff, 0x01, 0x80, 0x09, 0x00, 0x02, 0xff, 0x01, 0x20,
  0x04, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0xf0, 0x09, 0x00, 0x02, 0xff,
  0x01, 0x20, 0x04, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xf3, 0x09, 0x00,
  0x02, 0xff, 0x01, 0x20, 0x04, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xf6,
  0x09, 0x00, 0x02, 0xff, 0x01, 0x20, 0x04, 0x00, 0x01, 0x0d, 0x01, 0xff,
  0x01, 0xf7, 0x09, 0x00, 0x02, 0xff, 0x01, 0x20, 0x04, 0x00, 0x01, 0x0d,
  0x01, 0xff, 0x01, 0xf7, 0x09, 0x00, 0x02, 0xff, 0x01, 0x20, 0x04, 0x00,
  0x01, 0x0f, 0x01, 0xff, 0x01, 0xf6, 0x09, 0x00, 0x02, 0xff, 0x01, 0x20,
  0x04, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xf3, 0x09, 0x00, 0x02, 0xff,
  0x01, 0x20, 0x04, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0xf0, 0x09, 0x00,
  0x02, 0xff, 0x01, 0x20, 0x03, 0x00, 0x01, 0x1b, 0x02, 0xff, 0x01, 0x80,
  0x09, 0x00, 0x02, 0xff, 0x01, 0x65, 0x02, 0x55, 0x01, 0x7a, 0x02, 0xff,
  0x01, 0xfe, 0x01, 0x10, 0x09, 0x00, 0x08, 0xff, 0x01, 0xe2, 0x0a, 0x00,
  0x07, 0xff, 0x01, 0xfa, 0x01, 0x10, 0x0a, 0x00, 0x05, 0xff, 0x01, 0xed,
  0x01, 0xa7, 0x01, 0x10, 0x0b, 0x00, 0x02, 0xff, 0x01, 0x20, 0x10, 0x00,
  0x02, 0xff, 0x01, 0x20, 0x10, 0x00, 0x02, 0xff, 0x01, 0x20, 0x10, 0x00,
  0x02, 0xff, 0x01, 0x20, 0x10, 0x00, 0x02, 0xff, 0x01, 0x20, 0x10, 0x00,
  0x02, 0xff, 0x01, 0x20, 0x10, 0x00, 0x02, 0xcc, 0x01, 0x10, 0xcc, 0x00,

  /* 16 SML_THORN */
  0x86, 0x00, 0x01, 0x02, 0x01, 0x99, 0x01, 0x94, 0x10, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7,
  0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7,
  0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7,
  0x02, 0x00, 0x01, 0x13, 0x01, 0x54, 0x01, 0x20, 0x0b, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf7, 0x01, 0x00, 0x01, 0x5c, 0x02, 0xff, 0x01, 0xfd,
  0x01, 0x70, 0x0a, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x01, 0x0b,
  0x04, 0xff, 0x01, 0xfd, 0x01, 0x20, 0x09, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf7, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xec, 0x01, 0xdf, 0x02, 0xff,
  0x01, 0xe1, 0x09, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xfd, 0x01, 0xff,
  0x01, 0xc3, 0x02, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0xfc, 0x09, 0x00,
  0x01, 0x03, 0x02, 0xff, 0x01, 0xfa, 0x03, 0x00, 0x01, 0x02, 0x01, 0xef,
  0x01, 0xff, 0x01, 0x60, 0x08, 0x00, 0x01, 0x03, 0x02, 0xff, 0x01, 0xe0,
  0x04, 0x00, 0x01, 0x5f, 0x01, 0xff, 0x01, 0xd0, 0x08, 0x00, 0x01, 0x03,
  0x02, 0xff, 0x01, 0x60, 0x04, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xf3,
  0x08, 0x00, 0x01, 0x03, 0x02, 0xff, 0x05, 0x00, 0x01, 0x06, 0x01, 0xff,
  0x01, 0xf7, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xfc, 0x05, 0x00,
  0x01, 0x02, 0x01, 0xff, 0x01, 0xfb, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf9, 0x06, 0x00, 0x01, 0xff, 0x01, 0xfd, 0x08, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf8, 0x06, 0x00, 0x01, 0xef, 0x01, 0xfe, 0x08, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x06, 0x00, 0x01, 0xef, 0x01, 0xff,
  0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf8, 0x06, 0x00, 0x01, 0xef,
  0x01, 0xfe, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf9, 0x06, 0x00,
  0x01, 0xff, 0x01, 0xfd, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xfc,
  0x05, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xfb, 0x08, 0x00, 0x01, 0x03,
  0x02, 0xff, 0x05, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf8, 0x08, 0x00,
  0x01, 0x03, 0x02, 0xff, 0x01, 0x60, 0x04, 0x00, 0x01, 0x0c, 0x01, 0xff,
  0x01, 0xf3, 0x08, 0x00, 0x01, 0x03, 0x02, 0xff, 0x01, 0xd0, 0x04, 0x00,
  0x01, 0x5f, 0x01, 0xff, 0x01, 0xd0, 0x08, 0x00, 0x01, 0x03, 0x02, 0xff,
  0x01, 0xfa, 0x03, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0xff, 0x01, 0x60,
  0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xfd, 0x01, 0xff, 0x01, 0xb3,
  0x02, 0x00, 0x01, 0x6e, 0x01, 0xff, 0x01, 0xfc, 0x09, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf7, 0x01, 0xbf, 0x01, 0xff, 0x01, 0xec, 0x01, 0xcf,
  0x02, 0xff, 0x01, 0xe2, 0x09, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7,
  0x01, 0x0b, 0x04, 0xff, 0x01, 0xfd, 0x01, 0x20, 0x09, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf7, 0x01, 0x00, 0x01, 0x6c, 0x02, 0xff, 0x01, 0xfe,
  0x01, 0x70, 0x0a, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x02, 0x00,
  0x01, 0x23, 0x01, 0x54, 0x01, 0x20, 0x0b, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf7, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x10, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf7, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x10, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x03, 0x01, 0xff,
  0x01, 0xf7, 0x10, 0x00, 0x01, 0x01, 0x01, 0x66, 0x01, 0x63, 0x22, 0x00,
#endif // TOUCH_UI_UTF8_SCANDINAVIAN

#if ENABLED(TOUCH_UI_UTF8_PUNCTUATION)
  /* 17 LEFT_DBL_QUOTE */
  0xff, 0x00, 0x4a, 0x00, 0x01, 0x30, 0x03, 0x00, 0x01, 0x02, 0x0d, 0x00,
  0x01, 0x08, 0x01, 0xa0, 0x02, 0x00, 0x01, 0x01, 0x01, 0xc6, 0x0d, 0x00,
  0x01, 0xaf, 0x01, 0xa0, 0x02, 0x00, 0x01, 0x1d, 0x01, 0xf6, 0x0c, 0x00,
  0x01, 0x1c, 0x01, 0xff, 0x01, 0xa0, 0x01, 0x00, 0x01, 0x02, 0x01, 0xef,
  0x01, 0xf6, 0x0b, 0x00, 0x01, 0x01, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x50,
  0x01, 0x00, 0x01, 0x3e, 0x01, 0xff, 0x01, 0xe2, 0x0b, 0x00, 0x01, 0x2e,
  0x01, 0xff, 0x01, 0xf4, 0x01, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xfd,
  0x01, 0x20, 0x0a, 0x00, 0x01, 0x04, 0x01, 0xef, 0x01, 0xfe, 0x01, 0x30,
  0x01, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0xd1, 0x0b, 0x00, 0x01, 0x5f,
  0x01, 0xff, 0x01, 0xd2, 0x01, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xfb,
  0x0b, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xfc, 0x01, 0x10, 0x01, 0x00,
  0x01, 0xaf, 0x01, 0xff, 0x01, 0xa0, 0x0b, 0x00, 0x01, 0x0c, 0x01, 0xff,
  0x01, 0xd0, 0x02, 0x00, 0x01, 0xff, 0x01, 0xfa, 0x0c, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xf8, 0x02, 0x00, 0x01, 0xef, 0x01, 0xff, 0x01, 0x50,
  0x0c, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xa0, 0x01, 0x00, 0x01, 0x1c,
  0x01, 0xff, 0x01, 0xf6, 0x0c, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xfb,
  0x02, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x90, 0x0c, 0x00, 0x01, 0x6f,
  0x01, 0xff, 0x01, 0xd1, 0x01, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xfa,
  0x0c, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xfd, 0x01, 0x20, 0x01, 0x00,
  0x01, 0x8f, 0x01, 0xff, 0x01, 0xb0, 0x0c, 0x00, 0x01, 0x4f, 0x01, 0xff,
  0x01, 0xa0, 0x01, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf6, 0x0c, 0x00,
  0x01, 0x02, 0x01, 0xef, 0x01, 0xa0, 0x02, 0x00, 0x01, 0x5f, 0x01, 0xf6,
  0x0d, 0x00, 0x01, 0x1d, 0x01, 0xa0, 0x02, 0x00, 0x01, 0x04, 0x01, 0xe6,
  0x0d, 0x00, 0x01, 0x01, 0x01, 0x60, 0x03, 0x00, 0x01, 0x24, 0xff, 0x00,

  /* 18 RIGHT_DBL_QUOTE */
  0xff, 0x00, 0x46, 0x00, 0x01, 0x20, 0x03, 0x00, 0x01, 0x20, 0x0d, 0x00,
  0x01, 0x01, 0x01, 0xe3, 0x03, 0x00, 0x01, 0x5d, 0x01, 0x10, 0x0c, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0x50, 0x02, 0x00, 0x01, 0x5f, 0x01, 0xe2,
  0x0c, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf6, 0x02, 0x00, 0x01, 0x5f,
  0x01, 0xfe, 0x01, 0x30, 0x0c, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x80,
  0x01, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0xf5, 0x0c, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xfa, 0x01, 0x00, 0x01, 0x01, 0x01, 0xcf, 0x01, 0xff,
  0x01, 0x60, 0x0c, 0x00, 0x01, 0x8f, 0x01, 0xff, 0x01, 0xb0, 0x01, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0xf9, 0x0c, 0x00, 0x01, 0x06, 0x01, 0xff,
  0x01, 0xfc, 0x01, 0x10, 0x01, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xa0,
  0x0c, 0x00, 0x01, 0x5f, 0x01, 0xff, 0x01, 0xd1, 0x01, 0x00, 0x01, 0x08,
  0x01, 0xff, 0x01, 0xfb, 0x0c, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xf5,
  0x02, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0x10, 0x0b, 0x00, 0x01, 0x2d,
  0x01, 0xff, 0x01, 0xf3, 0x01, 0x00, 0x01, 0x04, 0x01, 0xff, 0x01, 0xfe,
  0x01, 0x10, 0x0a, 0x00, 0x01, 0x03, 0x01, 0xef, 0x01, 0xff, 0x01, 0x40,
  0x01, 0x00, 0x01, 0x5f, 0x01, 0xff, 0x01, 0xd2, 0x0b, 0x00, 0x01, 0x4f,
  0x01, 0xff, 0x01, 0xe3, 0x01, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xfc,
  0x01, 0x10, 0x0a, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xfd, 0x01, 0x10,
  0x01, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0xb0, 0x0b, 0x00, 0x01, 0x6f,
  0x01, 0xff, 0x01, 0xc1, 0x01, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf9,
  0x0b, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xfa, 0x02, 0x00, 0x01, 0x5f,
  0x01, 0xff, 0x01, 0x70, 0x0b, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0x90,
  0x02, 0x00, 0x01, 0x5f, 0x01, 0xf6, 0x0c, 0x00, 0x01, 0x01, 0x01, 0xf8,
  0x03, 0x00, 0x01, 0x5f, 0x01, 0x40, 0x0c, 0x00, 0x01, 0x01, 0x01, 0x50,
  0x03, 0x00, 0x01, 0x43, 0xff, 0x00, 0x04, 0x00,

  /* 19 INV_EXCLAMATION */
  0xff, 0x00, 0x34, 0x00, 0x01, 0xad, 0x01, 0xdd, 0x01, 0x40, 0x10, 0x00,
  0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf, 0x01, 0xff,
  0x01, 0x50, 0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00,
  0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0x34, 0x01, 0x44,
  0x01, 0x10, 0x49, 0x00, 0x01, 0x02, 0x01, 0x22, 0x11, 0x00, 0x01, 0x6f,
  0x01, 0xff, 0x11, 0x00, 0x01, 0x7f, 0x01, 0xff, 0x11, 0x00, 0x01, 0x7f,
  0x01, 0xff, 0x01, 0x10, 0x10, 0x00, 0x01, 0x8f, 0x01, 0xff, 0x01, 0x20,
  0x10, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0x30, 0x10, 0x00, 0x01, 0xaf,
  0x01, 0xff, 0x01, 0x30, 0x10, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x40,
  0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf,
  0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50,
  0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf,
  0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50,
  0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf,
  0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50,
  0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf,
  0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50,
  0x10, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0x34,
  0x01, 0x44, 0x01, 0x10, 0x33, 0x00,

  /* 20 INV_QUESTION */
  0xff, 0x00, 0x36, 0x00, 0x02, 0xdd, 0x11, 0x00, 0x02, 0xff, 0x11, 0x00,
  0x02, 0xff, 0x11, 0x00, 0x02, 0xff, 0x11, 0x00, 0x02, 0xff, 0x11, 0x00,
  0x02, 0x44, 0x37, 0x00, 0x01, 0xbc, 0x01, 0xcb, 0x11, 0x00, 0x01, 0xef,
  0x01, 0xfe, 0x11, 0x00, 0x01, 0xef, 0x01, 0xfe, 0x11, 0x00, 0x01, 0xef,
  0x01, 0xfe, 0x11, 0x00, 0x01, 0xff, 0x01, 0xfd, 0x10, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xfb, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xf6,
  0x10, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xd0, 0x0f, 0x00, 0x01, 0x0a,
  0x02, 0xff, 0x01, 0x30, 0x0f, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xf4,
  0x0f, 0x00, 0x01, 0x09, 0x02, 0xff, 0x01, 0x40, 0x0f, 0x00, 0x01, 0x7f,
  0x01, 0xff, 0x01, 0xf4, 0x0f, 0x00, 0x01, 0x03, 0x02, 0xff, 0x01, 0x40,
  0x0f, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf8, 0x10, 0x00, 0x01, 0x0f,
  0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x1f, 0x01, 0xff, 0x01, 0xf0,
  0x10, 0x00, 0x01, 0x0f, 0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x0e,
  0x01, 0xff, 0x01, 0xf8, 0x04, 0x00, 0x01, 0x05, 0x01, 0xd0, 0x0a, 0x00,
  0x01, 0x08, 0x02, 0xff, 0x01, 0x70, 0x02, 0x00, 0x01, 0x05, 0x01, 0xcf,
  0x01, 0xf0, 0x0a, 0x00, 0x01, 0x01, 0x01, 0xef, 0x01, 0xff, 0x01, 0xfe,
  0x01, 0x98, 0x01, 0x8b, 0x02, 0xff, 0x01, 0xf0, 0x0b, 0x00, 0x01, 0x3f,
  0x06, 0xff, 0x01, 0xc0, 0x0b, 0x00, 0x01, 0x02, 0x01, 0xcf, 0x04, 0xff,
  0x01, 0xc5, 0x0d, 0x00, 0x01, 0x03, 0x01, 0x8b, 0x01, 0xcc, 0x01, 0xb9,
  0x01, 0x62, 0x31, 0x00,
#endif // TOUCH_UI_UTF8_PUNCTUATION

#if ENABLED(TOUCH_UI_UTF8_CURRENCY)
  /* 21 CENT_SIGN */
  0xb1, 0x00, 0x01, 0x01, 0x01, 0x32, 0x11, 0x00, 0x01, 0x05, 0x01, 0xfb,
  0x11, 0x00, 0x01, 0x05, 0x01, 0xfb, 0x11, 0x00, 0x01, 0x05, 0x01, 0xfb,
  0x11, 0x00, 0x01, 0x05, 0x01, 0xfc, 0x11, 0x00, 0x01, 0x05, 0x01, 0xfc,
  0x11, 0x00, 0x01, 0x39, 0x01, 0xfd, 0x01, 0x42, 0x0e, 0x00, 0x01, 0x05,
  0x01, 0xbf, 0x03, 0xff, 0x01, 0xfb, 0x01, 0x50, 0x0b, 0x00, 0x01, 0x03,
  0x01, 0xcf, 0x05, 0xff, 0x01, 0xf6, 0x0b, 0x00, 0x01, 0x4f, 0x02, 0xff,
  0x02, 0xfe, 0x01, 0xce, 0x01, 0xff, 0x01, 0xf6, 0x0a, 0x00, 0x01, 0x02,
  0x02, 0xff, 0x01, 0xe6, 0x01, 0x05, 0x01, 0xfc, 0x01, 0x00, 0x01, 0x38,
  0x01, 0xe6, 0x0a, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xfd, 0x01, 0x10,
  0x01, 0x05, 0x01, 0xfc, 0x02, 0x00, 0x01, 0x02, 0x0a, 0x00, 0x01, 0x5f,
  0x01, 0xff, 0x01, 0xe1, 0x01, 0x00, 0x01, 0x05, 0x01, 0xfc, 0x0d, 0x00,
  0x01, 0xcf, 0x01, 0xff, 0x01, 0x60, 0x01, 0x00, 0x01, 0x05, 0x01, 0xfc,
  0x0d, 0x00, 0x02, 0xff, 0x02, 0x00, 0x01, 0x05, 0x01, 0xfc, 0x0c, 0x00,
  0x01, 0x04, 0x01, 0xff, 0x01, 0xfb, 0x02, 0x00, 0x01, 0x05, 0x01, 0xfc,
  0x0c, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf8, 0x02, 0x00, 0x01, 0x05,
  0x01, 0xfc, 0x0c, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf7, 0x02, 0x00,
  0x01, 0x05, 0x01, 0xfb, 0x0c, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xf6,
  0x02, 0x00, 0x01, 0x05, 0x01, 0xfc, 0x0c, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf7, 0x02, 0x00, 0x01, 0x05, 0x01, 0xfb, 0x0c, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xf9, 0x02, 0x00, 0x01, 0x05, 0x01, 0xfb, 0x0c, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xfc, 0x02, 0x00, 0x01, 0x05, 0x01, 0xfb,
  0x0d, 0x00, 0x02, 0xff, 0x01, 0x10, 0x01, 0x00, 0x01, 0x05, 0x01, 0xfb,
  0x0d, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0x80, 0x01, 0x00, 0x01, 0x05,
  0x01, 0xfb, 0x0d, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xf3, 0x01, 0x00,
  0x01, 0x05, 0x01, 0xfb, 0x0d, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0xfe,
  0x01, 0x30, 0x01, 0x05, 0x01, 0xfb, 0x02, 0x00, 0x01, 0x33, 0x0a, 0x00,
  0x01, 0x01, 0x01, 0xef, 0x01, 0xff, 0x01, 0xf9, 0x01, 0x35, 0x01, 0xfb,
  0x01, 0x02, 0x01, 0x6c, 0x01, 0xf6, 0x0b, 0x00, 0x01, 0x2d, 0x06, 0xff,
  0x01, 0xf6, 0x0b, 0x00, 0x01, 0x01, 0x01, 0x9f, 0x05, 0xff, 0x01, 0xf5,
  0x0c, 0x00, 0x01, 0x02, 0x01, 0x8d, 0x03, 0xff, 0x01, 0xc7, 0x01, 0x20,
  0x0e, 0x00, 0x01, 0x06, 0x01, 0xfc, 0x01, 0x20, 0x10, 0x00, 0x01, 0x05,
  0x01, 0xfb, 0x11, 0x00, 0x01, 0x05, 0x01, 0xfb, 0x11, 0x00, 0x01, 0x05,
  0x01, 0xfb, 0x11, 0x00, 0x01, 0x05, 0x01, 0xfb, 0x11, 0x00, 0x01, 0x05,
  0x01, 0xfb, 0x57, 0x00,

  /* 22 POUND_SIGN */
  0x9e, 0x00, 0x01, 0x6b, 0x01, 0xdf, 0x01, 0xfd, 0x01, 0xc9, 0x01, 0x40,
  0x0d, 0x00, 0x01, 0x6e, 0x05, 0xff, 0x01, 0x30, 0x0b, 0x00, 0x01, 0x07,
  0x06, 0xff, 0x01, 0x30, 0x0b, 0x00, 0x01, 0x3f, 0x01, 0xff, 0x01, 0xfe,
  0x01, 0x85, 0x01, 0x34, 0x01, 0x7b, 0x01, 0xff, 0x01, 0x30, 0x0b, 0x00,
  0x01, 0xaf, 0x01, 0xff, 0x01, 0xc1, 0x03, 0x00, 0x01, 0x18, 0x01, 0x30,
  0x0a, 0x00, 0x01, 0x01, 0x02, 0xff, 0x01, 0x30, 0x0f, 0x00, 0x01, 0x04,
  0x01, 0xff, 0x01, 0xfd, 0x10, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xfa,
  0x10, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xf8, 0x10, 0x00, 0x01, 0x09,
  0x01, 0xff, 0x01, 0xf7, 0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6,
  0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6,
  0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6, 0x0e, 0x00, 0x01, 0x0a,
  0x07, 0xff, 0x01, 0xf4, 0x0a, 0x00, 0x01, 0x0a, 0x07, 0xff, 0x01, 0xf4,
  0x0a, 0x00, 0x01, 0x08, 0x01, 0xdd, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xfe,
  0x03, 0xdd, 0x01, 0xd4, 0x0c, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6,
  0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6,
  0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6,
  0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xf6, 0x0e, 0x00, 0x01, 0x4b, 0x01, 0xbb, 0x01, 0xbe,
  0x01, 0xff, 0x01, 0xfd, 0x05, 0xbb, 0x01, 0x70, 0x08, 0x00, 0x01, 0x6f,
  0x09, 0xff, 0x01, 0xa0, 0x08, 0x00, 0x01, 0x6f, 0x09, 0xff, 0x01, 0xa0,
  0x08, 0x00, 0x01, 0x4a, 0x09, 0xaa, 0x01, 0x60, 0xc5, 0x00,

  /* 23 CURRENCY_SIGN */
  0xff, 0x00, 0x0d, 0x00, 0x01, 0x30, 0x07, 0x00, 0x01, 0x01, 0x01, 0x40,
  0x08, 0x00, 0x01, 0x0b, 0x01, 0xf5, 0x07, 0x00, 0x01, 0x1d, 0x01, 0xf4,
  0x08, 0x00, 0x01, 0xbf, 0x01, 0xff, 0x01, 0x40, 0x05, 0x00, 0x01, 0x01,
  0x01, 0xdf, 0x01, 0xff, 0x01, 0x30, 0x07, 0x00, 0x01, 0x5f, 0x01, 0xff,
  0x01, 0xf4, 0x01, 0x00, 0x01, 0x6b, 0x01, 0xdd, 0x01, 0xc8, 0x01, 0x20,
  0x01, 0x1d, 0x01, 0xff, 0x01, 0xfa, 0x08, 0x00, 0x01, 0x05, 0x02, 0xff,
  0x01, 0x8e, 0x03, 0xff, 0x01, 0xfa, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xa0,
  0x09, 0x00, 0x01, 0x5f, 0x07, 0xff, 0x01, 0xfa, 0x0a, 0x00, 0x01, 0x05,
  0x02, 0xff, 0x01, 0xe9, 0x01, 0x55, 0x01, 0x7c, 0x02, 0xff, 0x01, 0xa0,
  0x0a, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0xfb, 0x01, 0x10, 0x02, 0x00,
  0x01, 0x6f, 0x01, 0xff, 0x01, 0xa0, 0x0a, 0x00, 0x01, 0x0b, 0x01, 0xff,
  0x01, 0xc0, 0x03, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf2, 0x0a, 0x00,
  0x01, 0x1f, 0x01, 0xff, 0x01, 0x30, 0x04, 0x00, 0x01, 0xdf, 0x01, 0xf7,
  0x0a, 0x00, 0x01, 0x4f, 0x01, 0xfd, 0x05, 0x00, 0x01, 0x8f, 0x01, 0xfa,
  0x0a, 0x00, 0x01, 0x6f, 0x01, 0xfc, 0x05, 0x00, 0x01, 0x6f, 0x01, 0xfc,
  0x0a, 0x00, 0x01, 0x5f, 0x01, 0xfc, 0x05, 0x00, 0x01, 0x7f, 0x01, 0xfb,
  0x0a, 0x00, 0x01, 0x3f, 0x01, 0xff, 0x01, 0x10, 0x04, 0x00, 0x01, 0xbf,
  0x01, 0xf8, 0x0a, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0x80, 0x03, 0x00,
  0x01, 0x03, 0x01, 0xff, 0x01, 0xf3, 0x0a, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf5, 0x03, 0x00, 0x01, 0x1d, 0x01, 0xff, 0x01, 0xc0, 0x0a, 0x00,
  0x01, 0x01, 0x02, 0xff, 0x01, 0x92, 0x01, 0x00, 0x01, 0x16, 0x01, 0xef,
  0x01, 0xff, 0x01, 0x60, 0x0a, 0x00, 0x01, 0x1d, 0x03, 0xff, 0x01, 0xfe,
  0x03, 0xff, 0x01, 0xf4, 0x09, 0x00, 0x01, 0x01, 0x01, 0xdf, 0x05, 0xff,
  0x01, 0xfe, 0x02, 0xff, 0x01, 0x40, 0x08, 0x00, 0x01, 0x1d, 0x01, 0xff,
  0x01, 0xfa, 0x01, 0x06, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xfe, 0x01, 0x81,
  0x01, 0x5f, 0x01, 0xff, 0x01, 0xf4, 0x08, 0x00, 0x01, 0xcf, 0x01, 0xff,
  0x01, 0xa0, 0x01, 0x00, 0x01, 0x01, 0x01, 0x44, 0x01, 0x20, 0x01, 0x00,
  0x01, 0x05, 0x02, 0xff, 0x01, 0x20, 0x07, 0x00, 0x01, 0x4f, 0x01, 0xfa,
  0x07, 0x00, 0x01, 0x4f, 0x01, 0xf8, 0x08, 0x00, 0x01, 0x05, 0x01, 0xa0,
  0x07, 0x00, 0x01, 0x05, 0x01, 0x80, 0xeb, 0x00,

  /* 24 YEN_SIGN */
  0x98, 0x00, 0x01, 0x01, 0x01, 0x88, 0x01, 0x85, 0x07, 0x00, 0x01, 0x38,
  0x01, 0x88, 0x01, 0x40, 0x07, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x10,
  0x06, 0x00, 0x01, 0xcf, 0x01, 0xff, 0x01, 0x10, 0x07, 0x00, 0x01, 0x3f,
  0x01, 0xff, 0x01, 0x90, 0x05, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xf8,
  0x08, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0xf2, 0x05, 0x00, 0x01, 0x0d,
  0x01, 0xff, 0x01, 0xe0, 0x08, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xfa,
  0x05, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0x60, 0x09, 0x00, 0x01, 0xaf,
  0x01, 0xff, 0x01, 0x30, 0x04, 0x00, 0x01, 0xef, 0x01, 0xfd, 0x0a, 0x00,
  0x01, 0x1f, 0x01, 0xff, 0x01, 0xc0, 0x03, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf5, 0x0a, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xf4, 0x03, 0x00,
  0x01, 0x1f, 0x01, 0xff, 0x01, 0xc0, 0x0a, 0x00, 0x01, 0x01, 0x01, 0xef,
  0x01, 0xfd, 0x03, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0x40, 0x0b, 0x00,
  0x01, 0x7f, 0x01, 0xff, 0x01, 0x50, 0x01, 0x00, 0x01, 0x02, 0x01, 0xff,
  0x01, 0xfb, 0x0c, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xe0, 0x01, 0x00,
  0x01, 0x0a, 0x01, 0xff, 0x01, 0xf3, 0x0c, 0x00, 0x01, 0x06, 0x01, 0xff,
  0x01, 0xf7, 0x01, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0xa0, 0x0a, 0x00,
  0x01, 0x2a, 0x02, 0xaa, 0x01, 0xff, 0x01, 0xfe, 0x01, 0x10, 0x01, 0xbf,
  0x01, 0xff, 0x01, 0xca, 0x01, 0xaa, 0x01, 0xa5, 0x08, 0x00, 0x01, 0x4f,
  0x04, 0xff, 0x01, 0x83, 0x04, 0xff, 0x01, 0xf8, 0x08, 0x00, 0x01, 0x3c,
  0x02, 0xcc, 0x01, 0xce, 0x01, 0xff, 0x01, 0xfd, 0x01, 0xff, 0x01, 0xfc,
  0x02, 0xcc, 0x01, 0xc6, 0x0b, 0x00, 0x01, 0x03, 0x03, 0xff, 0x01, 0x70,
  0x0f, 0x00, 0x01, 0xaf, 0x01, 0xff, 0x01, 0xfe, 0x10, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0xf5, 0x0c, 0x00, 0x01, 0x01, 0x03, 0x11, 0x01, 0x1e,
  0x01, 0xff, 0x01, 0xf3, 0x03, 0x11, 0x01, 0x10, 0x08, 0x00, 0x01, 0x4f,
  0x09, 0xff, 0x01, 0xf8, 0x08, 0x00, 0x01, 0x4f, 0x09, 0xff, 0x01, 0xf8,
  0x08, 0x00, 0x01, 0x27, 0x03, 0x77, 0x01, 0x7e, 0x01, 0xff, 0x01, 0xf8,
  0x03, 0x77, 0x01, 0x73, 0x0c, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf2,
  0x10, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x0e,
  0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf2,
  0x10, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x0e,
  0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf2,
  0x10, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x08,
  0x01, 0x99, 0x01, 0x91, 0xc9, 0x00,
#endif // TOUCH_UI_UTF8_CURRENCY

#if ENABLED(TOUCH_UI_UTF8_SUPERSCRIPTS)
  /* 25 SUPERSCRIPT_ONE */
  0x99, 0x00, 0x01, 0x01, 0x01, 0x36, 0x01, 0x9b, 0x01, 0xbb, 0x01, 0x20,
  0x0e, 0x00, 0x01, 0x3f, 0x03, 0xff, 0x01, 0x20, 0x0e, 0x00, 0x01, 0x3f,
  0x01, 0xfe, 0x01, 0xbe, 0x01, 0xff, 0x01, 0x20, 0x0e, 0x00, 0x01, 0x14,
  0x01, 0x10, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20,
  0x10, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20,
  0x10, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20,
  0x10, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x10, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x0f, 0x00, 0x01, 0x11, 0x01, 0x1c, 0x01, 0xff,
  0x01, 0x31, 0x01, 0x11, 0x0d, 0x00, 0x01, 0x0d, 0x05, 0xff, 0x01, 0x40,
  0x0c, 0x00, 0x01, 0x0d, 0x05, 0xff, 0x01, 0x40, 0x0c, 0x00, 0x01, 0x01,
  0x05, 0x22, 0xff, 0x00, 0xc2, 0x00,

  /* 26 SUPERSCRIPT_TWO */
  0x88, 0x00, 0x01, 0x01, 0x10, 0x00, 0x01, 0x16, 0x01, 0xae, 0x01, 0xff,
  0x01, 0xfd, 0x01, 0x92, 0x0e, 0x00, 0x05, 0xff, 0x01, 0x60, 0x0d, 0x00,
  0x01, 0xfe, 0x01, 0x84, 0x01, 0x22, 0x01, 0x5c, 0x01, 0xff, 0x01, 0xf3,
  0x0d, 0x00, 0x01, 0x50, 0x03, 0x00, 0x01, 0xcf, 0x01, 0xfa, 0x11, 0x00,
  0x01, 0x5f, 0x01, 0xfc, 0x11, 0x00, 0x01, 0x5f, 0x01, 0xfb, 0x11, 0x00,
  0x01, 0xcf, 0x01, 0xf4, 0x10, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x6f, 0x01, 0xfe, 0x01, 0x10, 0x0f, 0x00, 0x01, 0x05,
  0x01, 0xff, 0x01, 0xe2, 0x10, 0x00, 0x01, 0x5f, 0x01, 0xff, 0x01, 0x30,
  0x0f, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xe3, 0x10, 0x00, 0x01, 0x6f,
  0x01, 0xfe, 0x01, 0x20, 0x0f, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xd1,
  0x10, 0x00, 0x01, 0xaf, 0x01, 0xfd, 0x01, 0x43, 0x03, 0x33, 0x0c, 0x00,
  0x01, 0x01, 0x06, 0xff, 0x0c, 0x00, 0x01, 0x01, 0x06, 0xff, 0x0d, 0x00,
  0x06, 0x22, 0xff, 0x00, 0xc2, 0x00,

  /* 27 SUPERSCRIPT_THREE */
  0x88, 0x00, 0x01, 0x01, 0x01, 0x10, 0x0f, 0x00, 0x01, 0x39, 0x01, 0xce,
  0x02, 0xff, 0x01, 0xb5, 0x0e, 0x00, 0x01, 0x7f, 0x04, 0xff, 0x01, 0xb0,
  0x0d, 0x00, 0x01, 0x6b, 0x01, 0x73, 0x01, 0x22, 0x01, 0x38, 0x01, 0xff,
  0x01, 0xf9, 0x11, 0x00, 0x01, 0x5f, 0x01, 0xff, 0x11, 0x00, 0x01, 0x0f,
  0x01, 0xff, 0x11, 0x00, 0x01, 0x4f, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x27,
  0x01, 0xff, 0x01, 0xf3, 0x0e, 0x00, 0x01, 0x0c, 0x02, 0xff, 0x01, 0xfa,
  0x01, 0x20, 0x0e, 0x00, 0x01, 0x0c, 0x02, 0xff, 0x01, 0xfb, 0x01, 0x40,
  0x0e, 0x00, 0x01, 0x01, 0x01, 0x23, 0x01, 0x49, 0x01, 0xff, 0x01, 0xf6,
  0x11, 0x00, 0x01, 0x3f, 0x01, 0xff, 0x01, 0x10, 0x10, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x50, 0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0x60,
  0x10, 0x00, 0x01, 0x1e, 0x01, 0xff, 0x01, 0x40, 0x0c, 0x00, 0x01, 0xa4,
  0x02, 0x00, 0x01, 0x05, 0x01, 0xdf, 0x01, 0xfd, 0x0d, 0x00, 0x02, 0xff,
  0x01, 0xde, 0x02, 0xff, 0x01, 0xe3, 0x0d, 0x00, 0x01, 0xae, 0x03, 0xff,
  0x01, 0xe9, 0x01, 0x10, 0x0e, 0x00, 0x01, 0x24, 0x01, 0x55, 0x01, 0x52,
  0xff, 0x00, 0xc4, 0x00,
#endif // TOUCH_UI_UTF8_SUPERSCRIPTS

#if ENABLED(TOUCH_UI_UTF8_ORDINALS)
  /* 28 MASCULINE_ORDINAL */
  0x89, 0x00, 0x01, 0x01, 0x01, 0x10, 0x0f, 0x00, 0x01, 0x01, 0x01, 0x8d,
  0x02, 0xff, 0x01, 0xb4, 0x0e, 0x00, 0x01, 0x4f, 0x04, 0xff, 0x01, 0xa0,
  0x0c, 0x00, 0x01, 0x04, 0x01, 0xff, 0x01, 0xfc, 0x01, 0x63, 0x01, 0x48,
  0x01, 0xff, 0x01, 0xfb, 0x0c, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xa0,
  0x02, 0x00, 0x01, 0x3f, 0x01, 0xff, 0x01, 0x60, 0x0b, 0x00, 0x01, 0x6f,
  0x01, 0xfe, 0x03, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xd0, 0x0b, 0x00,
  0x01, 0xbf, 0x01, 0xf7, 0x04, 0x00, 0x01, 0xff, 0x01, 0xf2, 0x0b, 0x00,
  0x01, 0xef, 0x01, 0xf3, 0x04, 0x00, 0x01, 0xcf, 0x01, 0xf6, 0x0b, 0x00,
  0x01, 0xff, 0x01, 0xf1, 0x04, 0x00, 0x01, 0xaf, 0x01, 0xf7, 0x0b, 0x00,
  0x01, 0xff, 0x01, 0xf1, 0x04, 0x00, 0x01, 0xaf, 0x01, 0xf7, 0x0b, 0x00,
  0x01, 0xff, 0x01, 0xf2, 0x04, 0x00, 0x01, 0xbf, 0x01, 0xf6, 0x0b, 0x00,
  0x01, 0xcf, 0x01, 0xf6, 0x04, 0x00, 0x01, 0xef, 0x01, 0xf4, 0x0b, 0x00,
  0x01, 0x8f, 0x01, 0xfc, 0x03, 0x00, 0x01, 0x04, 0x01, 0xff, 0x01, 0xf0,
  0x0b, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x60, 0x02, 0x00, 0x01, 0x1d,
  0x01, 0xff, 0x01, 0x90, 0x0b, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xf8,
  0x01, 0x10, 0x01, 0x04, 0x01, 0xdf, 0x01, 0xfe, 0x01, 0x10, 0x0c, 0x00,
  0x01, 0xaf, 0x04, 0xff, 0x01, 0xe3, 0x0d, 0x00, 0x01, 0x05, 0x01, 0xdf,
  0x02, 0xff, 0x01, 0xfa, 0x01, 0x10, 0x0e, 0x00, 0x01, 0x02, 0x01, 0x56,
  0x01, 0x64, 0x21, 0x00, 0x01, 0x16, 0x06, 0x66, 0x01, 0x40, 0x0b, 0x00,
  0x01, 0x3f, 0x06, 0xff, 0x01, 0xb0, 0x0b, 0x00, 0x01, 0x3f, 0x06, 0xff,
  0x01, 0xb0, 0x0b, 0x00, 0x01, 0x01, 0x06, 0x11, 0xff, 0x00, 0x75, 0x00,

  /* 29 FEMININE_ORDINAL */
  0x89, 0x00, 0x01, 0x12, 0x01, 0x10, 0x0f, 0x00, 0x01, 0x49, 0x01, 0xdf,
  0x02, 0xff, 0x01, 0xb4, 0x0d, 0x00, 0x01, 0x07, 0x05, 0xff, 0x01, 0xa0,
  0x0c, 0x00, 0x01, 0x07, 0x01, 0xfc, 0x01, 0x74, 0x01, 0x33, 0x01, 0x59,
  0x01, 0xff, 0x01, 0xf8, 0x0c, 0x00, 0x01, 0x03, 0x01, 0x20, 0x03, 0x00,
  0x01, 0x3f, 0x01, 0xff, 0x01, 0x10, 0x10, 0x00, 0x01, 0x09, 0x01, 0xff,
  0x01, 0x50, 0x0e, 0x00, 0x01, 0x01, 0x01, 0x11, 0x01, 0x16, 0x01, 0xff,
  0x01, 0x80, 0x0c, 0x00, 0x01, 0x05, 0x01, 0xae, 0x04, 0xff, 0x01, 0x90,
  0x0b, 0x00, 0x01, 0x01, 0x01, 0xcf, 0x05, 0xff, 0x01, 0xa0, 0x0b, 0x00,
  0x01, 0x0d, 0x01, 0xff, 0x01, 0xe9, 0x01, 0x65, 0x01, 0x44, 0x01, 0x48,
  0x01, 0xff, 0x01, 0xa0, 0x0b, 0x00, 0x01, 0x5f, 0x01, 0xfd, 0x01, 0x10,
  0x02, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xa0, 0x0b, 0x00, 0x01, 0x9f,
  0x01, 0xf6, 0x03, 0x00, 0x01, 0x09, 0x01, 0xff, 0x01, 0xa0, 0x0b, 0x00,
  0x01, 0xaf, 0x01, 0xf5, 0x03, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x01, 0xa0,
  0x0b, 0x00, 0x01, 0x9f, 0x01, 0xfa, 0x03, 0x00, 0x01, 0xaf, 0x01, 0xff,
  0x01, 0xa0, 0x0b, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0xa2, 0x01, 0x00,
  0x01, 0x3b, 0x02, 0xff, 0x01, 0xa0, 0x0b, 0x00, 0x01, 0x0a, 0x04, 0xff,
  0x01, 0xe7, 0x01, 0xff, 0x01, 0xa0, 0x0c, 0x00, 0x01, 0x8f, 0x02, 0xff,
  0x01, 0xf9, 0x01, 0x15, 0x01, 0xff, 0x01, 0xa0, 0x0d, 0x00, 0x01, 0x46,
  0x01, 0x64, 0x02, 0x00, 0x01, 0x11, 0x1f, 0x00, 0x01, 0x16, 0x06, 0x66,
  0x01, 0x40, 0x0b, 0x00, 0x01, 0x3f, 0x06, 0xff, 0x01, 0xb0, 0x0b, 0x00,
  0x01, 0x3f, 0x06, 0xff, 0x01, 0xb0, 0x0b, 0x00, 0x01, 0x01, 0x06, 0x11,
  0xff, 0x00, 0x75, 0x00,
#endif // TOUCH_UI_UTF8_ORDINALS

#if ENABLED(TOUCH_UI_UTF8_COPYRIGHT)
  /* 30 COPYRIGHT_SIGN */
  0xa0, 0x00, 0x01, 0x01, 0x01, 0x45, 0x01, 0x76, 0x01, 0x43, 0x0e, 0x00,
  0x01, 0x28, 0x01, 0xdf, 0x03, 0xff, 0x01, 0xe9, 0x01, 0x40, 0x0b, 0x00,
  0x01, 0x19, 0x02, 0xff, 0x01, 0xdb, 0x01, 0xab, 0x01, 0xce, 0x01, 0xff,
  0x01, 0xfb, 0x01, 0x30, 0x09, 0x00, 0x01, 0x03, 0x01, 0xef, 0x01, 0xfb,
  0x01, 0x50, 0x03, 0x00, 0x01, 0x38, 0x01, 0xff, 0x01, 0xf7, 0x09, 0x00,
  0x01, 0x6f, 0x01, 0xfc, 0x01, 0x30, 0x05, 0x00, 0x01, 0x19, 0x01, 0xff,
  0x01, 0xa0, 0x07, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xa0, 0x07, 0x00,
  0x01, 0x5f, 0x01, 0xfb, 0x07, 0x00, 0x01, 0x3f, 0x01, 0xf8, 0x03, 0x00,
  0x01, 0x46, 0x01, 0x88, 0x01, 0x65, 0x01, 0x10, 0x01, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0x80, 0x06, 0x00, 0x01, 0xef, 0x01, 0xa0, 0x01, 0x00,
  0x01, 0x01, 0x01, 0x9f, 0x03, 0xff, 0x01, 0xfc, 0x01, 0x60, 0x01, 0x00,
  0x01, 0x4f, 0x01, 0xf4, 0x05, 0x00, 0x01, 0x08, 0x01, 0xfd, 0x02, 0x00,
  0x01, 0x4e, 0x02, 0xff, 0x01, 0xed, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0,
  0x01, 0x00, 0x01, 0x08, 0x01, 0xfd, 0x05, 0x00, 0x01, 0x1f, 0x01, 0xf4,
  0x01, 0x00, 0x01, 0x04, 0x01, 0xff, 0x01, 0xfe, 0x01, 0x61, 0x01, 0x00,
  0x01, 0x01, 0x01, 0x4a, 0x01, 0xa0, 0x02, 0x00, 0x01, 0xef, 0x01, 0x60,
  0x04, 0x00, 0x01, 0x6f, 0x01, 0xc0, 0x01, 0x00, 0x01, 0x0e, 0x01, 0xff,
  0x01, 0xc1, 0x07, 0x00, 0x01, 0x7f, 0x01, 0xb0, 0x04, 0x00, 0x01, 0xbf,
  0x01, 0x60, 0x01, 0x00, 0x01, 0x7f, 0x01, 0xff, 0x01, 0x10, 0x07, 0x00,
  0x01, 0x1f, 0x01, 0xf0, 0x04, 0x00, 0x01, 0xff, 0x01, 0x20, 0x01, 0x00,
  0x01, 0xdf, 0x01, 0xf9, 0x08, 0x00, 0x01, 0x0d, 0x01, 0xf4, 0x03, 0x00,
  0x01, 0x01, 0x01, 0xfe, 0x01, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf4,
  0x08, 0x00, 0x01, 0x0a, 0x01, 0xf6, 0x03, 0x00, 0x01, 0x03, 0x01, 0xfd,
  0x01, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xf1, 0x08, 0x00, 0x01, 0x08,
  0x01, 0xf8, 0x03, 0x00, 0x01, 0x04, 0x01, 0xfc, 0x01, 0x00, 0x01, 0x03,
  0x01, 0xff, 0x01, 0xf0, 0x08, 0x00, 0x01, 0x07, 0x01, 0xf9, 0x03, 0x00,
  0x01, 0x03, 0x01, 0xfd, 0x01, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xf1,
  0x08, 0x00, 0x01, 0x08, 0x01, 0xf8, 0x03, 0x00, 0x01, 0x01, 0x01, 0xfe,
  0x01, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf3, 0x08, 0x00, 0x01, 0x09,
  0x01, 0xf7, 0x04, 0x00, 0x01, 0xff, 0x01, 0x10, 0x01, 0x00, 0x01, 0xdf,
  0x01, 0xf8, 0x08, 0x00, 0x01, 0x0c, 0x01, 0xf5, 0x04, 0x00, 0x01, 0xbf,
  0x01, 0x60, 0x01, 0x00, 0x01, 0x8f, 0x01, 0xfe, 0x01, 0x10, 0x07, 0x00,
  0x01, 0x1f, 0x01, 0xf1, 0x04, 0x00, 0x01, 0x6f, 0x01, 0xb0, 0x01, 0x00,
  0x01, 0x1f, 0x01, 0xff, 0x01, 0xb0, 0x07, 0x00, 0x01, 0x6f, 0x01, 0xc0,
  0x04, 0x00, 0x01, 0x1f, 0x01, 0xf4, 0x01, 0x00, 0x01, 0x05, 0x01, 0xff,
  0x01, 0xfd, 0x01, 0x50, 0x02, 0x00, 0x01, 0x29, 0x01, 0xa0, 0x02, 0x00,
  0x01, 0xef, 0x01, 0x60, 0x04, 0x00, 0x01, 0x08, 0x01, 0xfd, 0x02, 0x00,
  0x01, 0x6f, 0x02, 0xff, 0x01, 0xdb, 0x01, 0xce, 0x01, 0xff, 0x01, 0xb0,
  0x01, 0x00, 0x01, 0x07, 0x01, 0xfd, 0x05, 0x00, 0x01, 0x01, 0x01, 0xef,
  0x01, 0x90, 0x01, 0x00, 0x01, 0x02, 0x01, 0xbf, 0x03, 0xff, 0x01, 0xfe,
  0x01, 0x70, 0x01, 0x00, 0x01, 0x4f, 0x01, 0xf4, 0x06, 0x00, 0x01, 0x4f,
  0x01, 0xf7, 0x02, 0x00, 0x01, 0x01, 0x01, 0x58, 0x01, 0x9a, 0x01, 0x86,
  0x01, 0x30, 0x01, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0x80, 0x06, 0x00,
  0x01, 0x06, 0x01, 0xff, 0x01, 0x90, 0x07, 0x00, 0x01, 0x4f, 0x01, 0xfb,
  0x08, 0x00, 0x01, 0x6f, 0x01, 0xfc, 0x01, 0x30, 0x05, 0x00, 0x01, 0x18,
  0x01, 0xff, 0x01, 0xb0, 0x08, 0x00, 0x01, 0x04, 0x01, 0xef, 0x01, 0xfa,
  0x01, 0x40, 0x03, 0x00, 0x01, 0x27, 0x01, 0xef, 0x01, 0xf8, 0x0a, 0x00,
  0x01, 0x19, 0x02, 0xff, 0x01, 0xca, 0x01, 0x9a, 0x01, 0xbe, 0x01, 0xff,
  0x01, 0xfc, 0x01, 0x30, 0x0b, 0x00, 0x01, 0x29, 0x01, 0xdf, 0x03, 0xff,
  0x01, 0xfa, 0x01, 0x40, 0x0d, 0x00, 0x01, 0x02, 0x01, 0x46, 0x01, 0x76,
  0x01, 0x53, 0xc5, 0x00,

  /* 31 REGISTERED_SIGN */
  0xa0, 0x00, 0x01, 0x02, 0x01, 0x46, 0x01, 0x76, 0x01, 0x53, 0x0e, 0x00,
  0x01, 0x28, 0x01, 0xdf, 0x03, 0xff, 0x01, 0xea, 0x01, 0x40, 0x0b, 0x00,
  0x01, 0x19, 0x02, 0xff, 0x01, 0xcb, 0x01, 0x9a, 0x01, 0xce, 0x01, 0xff,
  0x01, 0xfc, 0x01, 0x30, 0x09, 0x00, 0x01, 0x04, 0x01, 0xef, 0x01, 0xfa,
  0x01, 0x40, 0x03, 0x00, 0x01, 0x38, 0x01, 0xff, 0x01, 0xf8, 0x09, 0x00,
  0x01, 0x6f, 0x01, 0xfc, 0x01, 0x30, 0x05, 0x00, 0x01, 0x18, 0x01, 0xff,
  0x01, 0xa0, 0x07, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0x90, 0x07, 0x00,
  0x01, 0x4f, 0x01, 0xfb, 0x07, 0x00, 0x01, 0x3f, 0x01, 0xf7, 0x01, 0x00,
  0x01, 0x13, 0x02, 0x33, 0x01, 0x32, 0x03, 0x00, 0x01, 0x02, 0x01, 0xff,
  0x01, 0x80, 0x06, 0x00, 0x01, 0xef, 0x01, 0xa0, 0x01, 0x00, 0x01, 0x7f,
  0x03, 0xff, 0x01, 0xfd, 0x01, 0x81, 0x02, 0x00, 0x01, 0x4f, 0x01, 0xf5,
  0x05, 0x00, 0x01, 0x08, 0x01, 0xfd, 0x02, 0x00, 0x01, 0x7f, 0x01, 0xff,
  0x01, 0xdd, 0x01, 0xef, 0x01, 0xff, 0x01, 0xfe, 0x01, 0x30, 0x01, 0x00,
  0x01, 0x08, 0x01, 0xfe, 0x05, 0x00, 0x01, 0x1f, 0x01, 0xf4, 0x02, 0x00,
  0x01, 0x7f, 0x01, 0xfa, 0x02, 0x00, 0x01, 0x3c, 0x01, 0xff, 0x01, 0xd0,
  0x02, 0x00, 0x01, 0xef, 0x01, 0x60, 0x04, 0x00, 0x01, 0x6f, 0x01, 0xc0,
  0x02, 0x00, 0x01, 0x7f, 0x01, 0xfa, 0x02, 0x00, 0x01, 0x02, 0x01, 0xff,
  0x01, 0xf3, 0x02, 0x00, 0x01, 0x7f, 0x01, 0xb0, 0x04, 0x00, 0x01, 0xbf,
  0x01, 0x60, 0x02, 0x00, 0x01, 0x7f, 0x01, 0xfa, 0x03, 0x00, 0x01, 0xff,
  0x01, 0xf4, 0x02, 0x00, 0x01, 0x1f, 0x01, 0xf0, 0x04, 0x00, 0x01, 0xff,
  0x01, 0x10, 0x02, 0x00, 0x01, 0x7f, 0x01, 0xfa, 0x03, 0x00, 0x01, 0xff,
  0x01, 0xf2, 0x02, 0x00, 0x01, 0x0c, 0x01, 0xf5, 0x03, 0x00, 0x01, 0x01,
  0x01, 0xfe, 0x03, 0x00, 0x01, 0x7f, 0x01, 0xfa, 0x02, 0x00, 0x01, 0x08,
  0x01, 0xff, 0x01, 0xe0, 0x02, 0x00, 0x01, 0x0a, 0x01, 0xf6, 0x03, 0x00,
  0x01, 0x03, 0x01, 0xfd, 0x03, 0x00, 0x01, 0x7f, 0x01, 0xfd, 0x01, 0x88,
  0x01, 0x9a, 0x01, 0xef, 0x01, 0xfe, 0x01, 0x30, 0x02, 0x00, 0x01, 0x08,
  0x01, 0xf8, 0x03, 0x00, 0x01, 0x04, 0x01, 0xfc, 0x03, 0x00, 0x01, 0x7f,
  0x03, 0xff, 0x01, 0xfe, 0x01, 0x91, 0x03, 0x00, 0x01, 0x07, 0x01, 0xf9,
  0x03, 0x00, 0x01, 0x03, 0x01, 0xfd, 0x03, 0x00, 0x01, 0x7f, 0x01, 0xfc,
  0x01, 0x78, 0x01, 0xdf, 0x01, 0xfd, 0x01, 0x20, 0x03, 0x00, 0x01, 0x08,
  0x01, 0xf8, 0x03, 0x00, 0x01, 0x01, 0x01, 0xfe, 0x03, 0x00, 0x01, 0x7f,
  0x01, 0xfa, 0x01, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0xc0, 0x03, 0x00,
  0x01, 0x09, 0x01, 0xf6, 0x04, 0x00, 0x01, 0xff, 0x01, 0x10, 0x02, 0x00,
  0x01, 0x7f, 0x01, 0xfa, 0x02, 0x00, 0x01, 0xdf, 0x01, 0xf8, 0x03, 0x00,
  0x01, 0x0c, 0x01, 0xf5, 0x04, 0x00, 0x01, 0xbf, 0x01, 0x60, 0x02, 0x00,
  0x01, 0x7f, 0x01, 0xfa, 0x02, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0x30,
  0x02, 0x00, 0x01, 0x1f, 0x01, 0xf1, 0x04, 0x00, 0x01, 0x6f, 0x01, 0xc0,
  0x02, 0x00, 0x01, 0x7f, 0x01, 0xfa, 0x02, 0x00, 0x01, 0x09, 0x01, 0xff,
  0x01, 0xd0, 0x02, 0x00, 0x01, 0x6f, 0x01, 0xb0, 0x04, 0x00, 0x01, 0x1f,
  0x01, 0xf4, 0x02, 0x00, 0x01, 0x7f, 0x01, 0xfa, 0x02, 0x00, 0x01, 0x01,
  0x01, 0xef, 0x01, 0xf7, 0x02, 0x00, 0x01, 0xef, 0x01, 0x60, 0x04, 0x00,
  0x01, 0x08, 0x01, 0xfd, 0x02, 0x00, 0x01, 0x7f, 0x01, 0xfa, 0x03, 0x00,
  0x01, 0x6f, 0x01, 0xff, 0x01, 0x20, 0x01, 0x08, 0x01, 0xfe, 0x06, 0x00,
  0x01, 0xef, 0x01, 0xa0, 0x01, 0x00, 0x01, 0x5a, 0x01, 0xa6, 0x03, 0x00,
  0x01, 0x09, 0x01, 0xaa, 0x01, 0x60, 0x01, 0x4f, 0x01, 0xf4, 0x06, 0x00,
  0x01, 0x3f, 0x01, 0xf8, 0x08, 0x00, 0x01, 0x03, 0x01, 0xff, 0x01, 0x80,
  0x06, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0x90, 0x07, 0x00, 0x01, 0x4f,
  0x01, 0xfb, 0x08, 0x00, 0x01, 0x6f, 0x01, 0xfc, 0x01, 0x30, 0x05, 0x00,
  0x01, 0x19, 0x01, 0xff, 0x01, 0xa0, 0x08, 0x00, 0x01, 0x04, 0x01, 0xef,
  0x01, 0xfa, 0x01, 0x40, 0x03, 0x00, 0x01, 0x38, 0x01, 0xef, 0x01, 0xf8,
  0x0a, 0x00, 0x01, 0x19, 0x02, 0xff, 0x01, 0xcb, 0x01, 0x9a, 0x01, 0xce,
  0x01, 0xff, 0x01, 0xfc, 0x01, 0x30, 0x0b, 0x00, 0x01, 0x28, 0x01, 0xdf,
  0x03, 0xff, 0x01, 0xea, 0x01, 0x40, 0x0d, 0x00, 0x01, 0x02, 0x01, 0x45,
  0x01, 0x76, 0x01, 0x43, 0xc5, 0x00,
#endif // TOUCH_UI_UTF8_COPYRIGHT

#if ENABLED(TOUCH_UI_UTF8_MATHEMATICS)
  /* 32 PLUS_MINUS_SIGN */
  0xeb, 0x00, 0x01, 0x02, 0x01, 0x77, 0x01, 0x70, 0x10, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0,
  0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0,
  0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xf0, 0x0b, 0x00, 0x01, 0x6a, 0x04, 0xaa, 0x01, 0xac,
  0x01, 0xff, 0x01, 0xfa, 0x05, 0xaa, 0x01, 0x20, 0x05, 0x00, 0x01, 0x9f,
  0x0c, 0xff, 0x01, 0x40, 0x05, 0x00, 0x01, 0x9f, 0x0c, 0xff, 0x01, 0x40,
  0x05, 0x00, 0x01, 0x7c, 0x04, 0xcc, 0x01, 0xcd, 0x01, 0xff, 0x01, 0xfc,
  0x05, 0xcc, 0x01, 0x30, 0x0a, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0,
  0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0,
  0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06,
  0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf0,
  0x10, 0x00, 0x01, 0x03, 0x01, 0x99, 0x01, 0x90, 0x44, 0x00, 0x01, 0x9f,
  0x0c, 0xff, 0x01, 0x30, 0x05, 0x00, 0x01, 0x9f, 0x0c, 0xff, 0x01, 0x40,
  0x05, 0x00, 0x01, 0x9f, 0x0c, 0xff, 0x01, 0x40, 0x05, 0x00, 0x01, 0x47,
  0x0c, 0x77, 0x01, 0x10, 0xc1, 0x00,

  /* 33 MULTIPLICATION_SIGN */
  0xff, 0x00, 0x0e, 0x00, 0x01, 0x09, 0x01, 0xb0, 0x07, 0x00, 0x01, 0x03,
  0x01, 0xe4, 0x08, 0x00, 0x01, 0x9f, 0x01, 0xfb, 0x07, 0x00, 0x01, 0x3e,
  0x01, 0xff, 0x01, 0x40, 0x06, 0x00, 0x01, 0x01, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xb0, 0x05, 0x00, 0x01, 0x03, 0x01, 0xef, 0x01, 0xff, 0x01, 0xa0,
  0x07, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0xfb, 0x05, 0x00, 0x01, 0x3e,
  0x01, 0xff, 0x01, 0xfb, 0x08, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xb0, 0x03, 0x00, 0x01, 0x03, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0,
  0x09, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0xfb, 0x03, 0x00, 0x01, 0x3e,
  0x01, 0xff, 0x01, 0xfb, 0x0a, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xb0, 0x01, 0x00, 0x01, 0x03, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0,
  0x0b, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0xfb, 0x01, 0x00, 0x01, 0x3e,
  0x01, 0xff, 0x01, 0xfb, 0x0c, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xb3, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0, 0x0d, 0x00, 0x01, 0x3e,
  0x03, 0xff, 0x01, 0xfb, 0x0e, 0x00, 0x01, 0x03, 0x01, 0xef, 0x02, 0xff,
  0x01, 0xb0, 0x0f, 0x00, 0x01, 0x5f, 0x02, 0xff, 0x01, 0x10, 0x0e, 0x00,
  0x01, 0x03, 0x01, 0xef, 0x02, 0xff, 0x01, 0xb0, 0x0e, 0x00, 0x01, 0x3e,
  0x03, 0xff, 0x01, 0xfb, 0x0d, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xb3, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0, 0x0c, 0x00, 0x01, 0x2e,
  0x01, 0xff, 0x01, 0xfb, 0x01, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0xfb,
  0x0b, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0, 0x01, 0x00,
  0x01, 0x02, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0, 0x0a, 0x00, 0x01, 0x2e,
  0x01, 0xff, 0x01, 0xfb, 0x03, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0xfb,
  0x09, 0x00, 0x01, 0x02, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0, 0x03, 0x00,
  0x01, 0x02, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0, 0x08, 0x00, 0x01, 0x2e,
  0x01, 0xff, 0x01, 0xfb, 0x05, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0xfb,
  0x07, 0x00, 0x01, 0x01, 0x01, 0xef, 0x01, 0xff, 0x01, 0xb0, 0x05, 0x00,
  0x01, 0x02, 0x01, 0xef, 0x01, 0xff, 0x01, 0xa0, 0x07, 0x00, 0x01, 0x8f,
  0x01, 0xfb, 0x07, 0x00, 0x01, 0x2e, 0x01, 0xff, 0x01, 0x40, 0x07, 0x00,
  0x01, 0x09, 0x01, 0xb0, 0x07, 0x00, 0x01, 0x02, 0x01, 0xe4, 0xe9, 0x00,

  /* 34 DIVISION_SIGN */
  0xff, 0x00, 0x25, 0x00, 0x01, 0x17, 0x01, 0x77, 0x01, 0x76, 0x10, 0x00,
  0x01, 0x2f, 0x01, 0xff, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x2f, 0x01, 0xff,
  0x01, 0xfc, 0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0xfc, 0x10, 0x00,
  0x01, 0x2f, 0x01, 0xff, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x17, 0x01, 0x77,
  0x01, 0x76, 0x31, 0x00, 0x01, 0x24, 0x0c, 0x44, 0x01, 0x10, 0x05, 0x00,
  0x01, 0x9f, 0x0c, 0xff, 0x01, 0x40, 0x05, 0x00, 0x01, 0x9f, 0x0c, 0xff,
  0x01, 0x40, 0x05, 0x00, 0x01, 0x9f, 0x0c, 0xff, 0x01, 0x40, 0x05, 0x00,
  0x01, 0x12, 0x0c, 0x22, 0x31, 0x00, 0x01, 0x18, 0x01, 0x88, 0x01, 0x87,
  0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0xfc,
  0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0xfc, 0x10, 0x00, 0x01, 0x16,
  0x01, 0x66, 0x01, 0x65, 0xff, 0x00, 0x01, 0x00,
#endif // TOUCH_UI_UTF8_MATHEMATICS

#if ENABLED(TOUCH_UI_UTF8_FRACTIONS)
  /* 35 FRACTION_QUARTER */
  0x92, 0x00, 0x01, 0x01, 0x01, 0x44, 0x01, 0x40, 0x04, 0x00, 0x01, 0x04,
  0x01, 0x79, 0x01, 0xce, 0x01, 0xee, 0x01, 0x20, 0x07, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0x90, 0x04, 0x00, 0x01, 0x3f, 0x03, 0xff, 0x01, 0x20,
  0x07, 0x00, 0x01, 0x3f, 0x01, 0xfe, 0x01, 0x10, 0x04, 0x00, 0x01, 0x3f,
  0x01, 0xdb, 0x01, 0x8d, 0x01, 0xff, 0x01, 0x20, 0x07, 0x00, 0x01, 0xdf,
  0x01, 0xf5, 0x05, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x0b, 0x01, 0xff,
  0x01, 0x20, 0x06, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xc0, 0x07, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x06, 0x00, 0x01, 0x1f, 0x01, 0xff,
  0x01, 0x20, 0x07, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x06, 0x00,
  0x01, 0xaf, 0x01, 0xf8, 0x08, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20,
  0x05, 0x00, 0x01, 0x04, 0x01, 0xff, 0x01, 0xe1, 0x08, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x05, 0x00, 0x01, 0x0d, 0x01, 0xff, 0x01, 0x50,
  0x08, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x05, 0x00, 0x01, 0x7f,
  0x01, 0xfc, 0x09, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x04, 0x00,
  0x01, 0x01, 0x01, 0xff, 0x01, 0xf2, 0x09, 0x00, 0x01, 0x0b, 0x01, 0xff,
  0x01, 0x20, 0x04, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0x80, 0x09, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x04, 0x00, 0x01, 0x4f, 0x01, 0xfe,
  0x0a, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x04, 0x00, 0x01, 0xdf,
  0x01, 0xf5, 0x0a, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x03, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xb0, 0x04, 0x00, 0x01, 0x37, 0x01, 0x77,
  0x02, 0x00, 0x01, 0x04, 0x01, 0x55, 0x01, 0x5d, 0x01, 0xff, 0x01, 0x75,
  0x01, 0x55, 0x01, 0x10, 0x01, 0x00, 0x01, 0x1f, 0x01, 0xff, 0x01, 0x20,
  0x03, 0x00, 0x01, 0x01, 0x01, 0xef, 0x01, 0xff, 0x02, 0x00, 0x01, 0x0d,
  0x05, 0xff, 0x01, 0x40, 0x01, 0x00, 0x01, 0xaf, 0x01, 0xf8, 0x04, 0x00,
  0x01, 0x0c, 0x02, 0xff, 0x02, 0x00, 0x01, 0x0c, 0x05, 0xee, 0x01, 0x40,
  0x01, 0x04, 0x01, 0xff, 0x01, 0xe0, 0x04, 0x00, 0x01, 0x8f, 0x01, 0xbe,
  0x01, 0xff, 0x09, 0x00, 0x01, 0x0d, 0x01, 0xff, 0x01, 0x50, 0x03, 0x00,
  0x01, 0x04, 0x01, 0xfe, 0x01, 0x1e, 0x01, 0xff, 0x09, 0x00, 0x01, 0x7f,
  0x01, 0xfc, 0x04, 0x00, 0x01, 0x1e, 0x01, 0xf4, 0x01, 0x0e, 0x01, 0xff,
  0x08, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf2, 0x04, 0x00, 0x01, 0xbf,
  0x01, 0x80, 0x01, 0x0e, 0x01, 0xff, 0x08, 0x00, 0x01, 0x0b, 0x01, 0xff,
  0x01, 0x80, 0x03, 0x00, 0x01, 0x08, 0x01, 0xfc, 0x01, 0x00, 0x01, 0x0e,
  0x01, 0xff, 0x08, 0x00, 0x01, 0x4f, 0x01, 0xfe, 0x04, 0x00, 0x01, 0x4f,
  0x01, 0xe1, 0x01, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x08, 0x00, 0x01, 0xdf,
  0x01, 0xf5, 0x03, 0x00, 0x01, 0x01, 0x01, 0xef, 0x01, 0x40, 0x01, 0x00,
  0x01, 0x0e, 0x01, 0xff, 0x07, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xb0,
  0x03, 0x00, 0x01, 0x0b, 0x01, 0xf8, 0x02, 0x00, 0x01, 0x0e, 0x01, 0xff,
  0x07, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x20, 0x03, 0x00, 0x01, 0x3f,
  0x01, 0xf8, 0x02, 0x88, 0x01, 0x8f, 0x01, 0xff, 0x01, 0x88, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xf8, 0x04, 0x00, 0x01, 0x4f, 0x06, 0xff, 0x05, 0x00,
  0x01, 0x04, 0x01, 0xff, 0x01, 0xe0, 0x04, 0x00, 0x01, 0x2a, 0x03, 0xaa,
  0x01, 0xaf, 0x01, 0xff, 0x01, 0xaa, 0x05, 0x00, 0x01, 0x0d, 0x01, 0xff,
  0x01, 0x50, 0x08, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x06, 0x00, 0x01, 0x8f,
  0x01, 0xfb, 0x09, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x05, 0x00, 0x01, 0x02,
  0x01, 0xff, 0x01, 0xf2, 0x09, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x05, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0x80, 0x09, 0x00, 0x01, 0x05, 0x01, 0x66,
  0xbf, 0x00,

  /* 36 FRACTION_HALF */
  0x92, 0x00, 0x01, 0x01, 0x01, 0x44, 0x01, 0x40, 0x04, 0x00, 0x01, 0x04,
  0x01, 0x7a, 0x01, 0xce, 0x01, 0xee, 0x01, 0x20, 0x07, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0x80, 0x04, 0x00, 0x01, 0x3f, 0x03, 0xff, 0x01, 0x20,
  0x07, 0x00, 0x01, 0x4f, 0x01, 0xfe, 0x05, 0x00, 0x01, 0x3f, 0x01, 0xda,
  0x01, 0x7d, 0x01, 0xff, 0x01, 0x20, 0x07, 0x00, 0x01, 0xdf, 0x01, 0xf5,
  0x07, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x06, 0x00, 0x01, 0x07,
  0x01, 0xff, 0x01, 0xc0, 0x07, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20,
  0x06, 0x00, 0x01, 0x1f, 0x01, 0xff, 0x01, 0x20, 0x07, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x06, 0x00, 0x01, 0xaf, 0x01, 0xf8, 0x08, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x05, 0x00, 0x01, 0x04, 0x01, 0xff,
  0x01, 0xe0, 0x08, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x05, 0x00,
  0x01, 0x0d, 0x01, 0xff, 0x01, 0x50, 0x08, 0x00, 0x01, 0x0b, 0x01, 0xff,
  0x01, 0x20, 0x05, 0x00, 0x01, 0x7f, 0x01, 0xfc, 0x09, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x04, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf2,
  0x09, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20, 0x04, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0x80, 0x09, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0x20,
  0x04, 0x00, 0x01, 0x4f, 0x01, 0xfe, 0x0a, 0x00, 0x01, 0x0b, 0x01, 0xff,
  0x01, 0x20, 0x04, 0x00, 0x01, 0xdf, 0x01, 0xf5, 0x0a, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0x20, 0x03, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xb0,
  0x01, 0x00, 0x01, 0x04, 0x01, 0x8a, 0x01, 0xcc, 0x01, 0xa7, 0x01, 0x10,
  0x02, 0x00, 0x01, 0x04, 0x01, 0x55, 0x01, 0x5d, 0x01, 0xff, 0x01, 0x75,
  0x01, 0x55, 0x01, 0x10, 0x01, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x20,
  0x01, 0x06, 0x04, 0xff, 0x01, 0xf7, 0x02, 0x00, 0x01, 0x0d, 0x05, 0xff,
  0x01, 0x40, 0x01, 0x00, 0x01, 0xbf, 0x01, 0xf8, 0x01, 0x00, 0x01, 0x08,
  0x01, 0xff, 0x01, 0xa7, 0x01, 0x68, 0x01, 0xdf, 0x01, 0xff, 0x01, 0x70,
  0x01, 0x00, 0x01, 0x0b, 0x05, 0xdd, 0x01, 0x40, 0x01, 0x04, 0x01, 0xff,
  0x01, 0xe0, 0x01, 0x00, 0x01, 0x05, 0x01, 0x60, 0x02, 0x00, 0x01, 0x08,
  0x01, 0xff, 0x01, 0xf1, 0x08, 0x00, 0x01, 0x0d, 0x01, 0xff, 0x01, 0x50,
  0x06, 0x00, 0x01, 0xef, 0x01, 0xf4, 0x08, 0x00, 0x01, 0x7f, 0x01, 0xfb,
  0x07, 0x00, 0x01, 0xcf, 0x01, 0xf3, 0x07, 0x00, 0x01, 0x02, 0x01, 0xff,
  0x01, 0xf2, 0x06, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xe0, 0x07, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0x80, 0x06, 0x00, 0x01, 0x0d, 0x01, 0xff,
  0x01, 0x50, 0x07, 0x00, 0x01, 0x4f, 0x01, 0xfe, 0x07, 0x00, 0x01, 0xaf,
  0x01, 0xfa, 0x08, 0x00, 0x01, 0xdf, 0x01, 0xf5, 0x06, 0x00, 0x01, 0x09,
  0x01, 0xff, 0x01, 0xc0, 0x07, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xb0,
  0x06, 0x00, 0x01, 0x8f, 0x01, 0xfd, 0x01, 0x10, 0x07, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0x20, 0x05, 0x00, 0x01, 0x09, 0x01, 0xff, 0x01, 0xc1,
  0x08, 0x00, 0x01, 0xbf, 0x01, 0xf8, 0x06, 0x00, 0x01, 0xaf, 0x01, 0xfb,
  0x08, 0x00, 0x01, 0x05, 0x01, 0xff, 0x01, 0xe0, 0x05, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0xa0, 0x08, 0x00, 0x01, 0x0d, 0x01, 0xff, 0x01, 0x50,
  0x04, 0x00, 0x01, 0x01, 0x01, 0xcf, 0x01, 0xf9, 0x09, 0x00, 0x01, 0x8f,
  0x01, 0xfb, 0x05, 0x00, 0x01, 0x09, 0x01, 0xff, 0x01, 0xfe, 0x03, 0xee,
  0x01, 0xe6, 0x04, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xf2, 0x05, 0x00,
  0x01, 0x0a, 0x05, 0xff, 0x01, 0xf7, 0x04, 0x00, 0x01, 0x0a, 0x01, 0xee,
  0x01, 0x70, 0x05, 0x00, 0x01, 0x04, 0x05, 0x66, 0x01, 0x62, 0xbe, 0x00,

  /* 37 FRACTION_THREE_FOURTHS */
  0x87, 0x00, 0x01, 0x02, 0x01, 0x34, 0x01, 0x42, 0x08, 0x00, 0x01, 0x01,
  0x01, 0x55, 0x01, 0x50, 0x04, 0x00, 0x01, 0x4c, 0x03, 0xff, 0x01, 0xe9,
  0x01, 0x10, 0x06, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0x80, 0x04, 0x00,
  0x01, 0x7f, 0x01, 0xff, 0x01, 0xfe, 0x02, 0xff, 0x01, 0xe2, 0x06, 0x00,
  0x01, 0x4f, 0x01, 0xfe, 0x05, 0x00, 0x01, 0x47, 0x01, 0x30, 0x01, 0x00,
  0x01, 0x05, 0x01, 0xef, 0x01, 0xfb, 0x06, 0x00, 0x01, 0xdf, 0x01, 0xf5,
  0x09, 0x00, 0x01, 0x3f, 0x01, 0xff, 0x05, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xb0, 0x09, 0x00, 0x01, 0x1f, 0x01, 0xff, 0x05, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0x20, 0x09, 0x00, 0x01, 0x6f, 0x01, 0xfb, 0x05, 0x00,
  0x01, 0xbf, 0x01, 0xf8, 0x07, 0x00, 0x01, 0x03, 0x01, 0x44, 0x01, 0x5a,
  0x01, 0xff, 0x01, 0xd1, 0x04, 0x00, 0x01, 0x04, 0x01, 0xff, 0x01, 0xe0,
  0x07, 0x00, 0x01, 0x0c, 0x02, 0xff, 0x01, 0xe7, 0x05, 0x00, 0x01, 0x0d,
  0x01, 0xff, 0x01, 0x50, 0x07, 0x00, 0x01, 0x0b, 0x01, 0xef, 0x01, 0xff,
  0x01, 0xfe, 0x01, 0x70, 0x04, 0x00, 0x01, 0x7f, 0x01, 0xfb, 0x0a, 0x00,
  0x01, 0x16, 0x01, 0xdf, 0x01, 0xf9, 0x03, 0x00, 0x01, 0x02, 0x01, 0xff,
  0x01, 0xf2, 0x0b, 0x00, 0x01, 0x1e, 0x01, 0xff, 0x01, 0x20, 0x02, 0x00,
  0x01, 0x0b, 0x01, 0xff, 0x01, 0x80, 0x0b, 0x00, 0x01, 0x0a, 0x01, 0xff,
  0x01, 0x60, 0x02, 0x00, 0x01, 0x4f, 0x01, 0xfe, 0x0c, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0x60, 0x02, 0x00, 0x01, 0xdf, 0x01, 0xf5, 0x0c, 0x00,
  0x01, 0x2f, 0x01, 0xff, 0x01, 0x30, 0x01, 0x00, 0x01, 0x08, 0x01, 0xff,
  0x01, 0xb0, 0x04, 0x00, 0x01, 0x47, 0x01, 0x77, 0x02, 0x00, 0x01, 0xd7,
  0x01, 0x42, 0x01, 0x01, 0x01, 0x38, 0x01, 0xef, 0x01, 0xfc, 0x02, 0x00,
  0x01, 0x2f, 0x01, 0xff, 0x01, 0x20, 0x03, 0x00, 0x01, 0x02, 0x02, 0xff,
  0x02, 0x00, 0x05, 0xff, 0x01, 0xc1, 0x02, 0x00, 0x01, 0xbf, 0x01, 0xf8,
  0x04, 0x00, 0x01, 0x0c, 0x02, 0xff, 0x02, 0x00, 0x01, 0x7b, 0x01, 0xef,
  0x02, 0xff, 0x01, 0xb6, 0x02, 0x00, 0x01, 0x04, 0x01, 0xff, 0x01, 0xe0,
  0x04, 0x00, 0x01, 0x9f, 0x01, 0xbe, 0x01, 0xff, 0x04, 0x00, 0x01, 0x22,
  0x01, 0x10, 0x03, 0x00, 0x01, 0x0d, 0x01, 0xff, 0x01, 0x50, 0x03, 0x00,
  0x01, 0x04, 0x01, 0xfe, 0x01, 0x1e, 0x01, 0xff, 0x09, 0x00, 0x01, 0x8f,
  0x01, 0xfb, 0x04, 0x00, 0x01, 0x1e, 0x01, 0xf3, 0x01, 0x0e, 0x01, 0xff,
  0x08, 0x00, 0x01, 0x02, 0x01, 0xff, 0x01, 0xf2, 0x04, 0x00, 0x01, 0xcf,
  0x01, 0x70, 0x01, 0x0e, 0x01, 0xff, 0x08, 0x00, 0x01, 0x0b, 0x01, 0xff,
  0x01, 0x80, 0x03, 0x00, 0x01, 0x08, 0x01, 0xfb, 0x01, 0x00, 0x01, 0x0e,
  0x01, 0xff, 0x08, 0x00, 0x01, 0x5f, 0x01, 0xfe, 0x04, 0x00, 0x01, 0x4f,
  0x01, 0xe1, 0x01, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x08, 0x00, 0x01, 0xdf,
  0x01, 0xf4, 0x03, 0x00, 0x01, 0x01, 0x01, 0xef, 0x01, 0x40, 0x01, 0x00,
  0x01, 0x0e, 0x01, 0xff, 0x07, 0x00, 0x01, 0x08, 0x01, 0xff, 0x01, 0xb0,
  0x03, 0x00, 0x01, 0x0b, 0x01, 0xf8, 0x02, 0x00, 0x01, 0x0e, 0x01, 0xff,
  0x07, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x20, 0x03, 0x00, 0x01, 0x3f,
  0x01, 0xf9, 0x02, 0x99, 0x01, 0x9f, 0x01, 0xff, 0x01, 0x99, 0x06, 0x00,
  0x01, 0xbf, 0x01, 0xf8, 0x04, 0x00, 0x01, 0x4f, 0x06, 0xff, 0x05, 0x00,
  0x01, 0x05, 0x01, 0xff, 0x01, 0xd0, 0x04, 0x00, 0x01, 0x29, 0x03, 0x99,
  0x01, 0x9f, 0x01, 0xff, 0x01, 0x99, 0x05, 0x00, 0x01, 0x0d, 0x01, 0xff,
  0x01, 0x40, 0x08, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x06, 0x00, 0x01, 0x8f,
  0x01, 0xfb, 0x09, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x05, 0x00, 0x01, 0x02,
  0x01, 0xff, 0x01, 0xf2, 0x09, 0x00, 0x01, 0x0e, 0x01, 0xff, 0x05, 0x00,
  0x01, 0x0a, 0x01, 0xee, 0x01, 0x70, 0x09, 0x00, 0x01, 0x04, 0x01, 0x55,
  0xbf, 0x00,
#endif // TOUCH_UI_UTF8_FRACTIONS

#if ENABLED(TOUCH_UI_UTF8_SYMBOLS)
  /* 38 MICRON_SIGN */
  0xff, 0x00, 0x1f, 0x00, 0x01, 0x02, 0x01, 0x44, 0x01, 0x40, 0x05, 0x00,
  0x01, 0x14, 0x01, 0x44, 0x01, 0x10, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff,
  0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00,
  0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff,
  0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00,
  0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff,
  0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00,
  0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff,
  0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00,
  0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x05, 0x00, 0x01, 0x4f, 0x01, 0xff,
  0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf4, 0x05, 0x00,
  0x01, 0x6f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf6, 0x05, 0x00, 0x01, 0x9f, 0x01, 0xff, 0x01, 0x70, 0x08, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xfa, 0x05, 0x00, 0x01, 0xef, 0x01, 0xff,
  0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x02, 0xff, 0x01, 0x20, 0x03, 0x00,
  0x01, 0x07, 0x02, 0xff, 0x01, 0x70, 0x08, 0x00, 0x01, 0x07, 0x02, 0xff,
  0x01, 0xd2, 0x03, 0x00, 0x01, 0x6f, 0x02, 0xff, 0x01, 0xa0, 0x08, 0x00,
  0x01, 0x07, 0x03, 0xff, 0x01, 0xa6, 0x01, 0x55, 0x01, 0x8d, 0x03, 0xff,
  0x01, 0xf9, 0x01, 0xa4, 0x07, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf7,
  0x05, 0xff, 0x01, 0x5d, 0x02, 0xff, 0x01, 0xf4, 0x07, 0x00, 0x01, 0x07,
  0x01, 0xff, 0x01, 0xf3, 0x01, 0x5f, 0x03, 0xff, 0x01, 0xf5, 0x01, 0x06,
  0x02, 0xff, 0x01, 0xf4, 0x07, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf3,
  0x01, 0x01, 0x01, 0x7c, 0x01, 0xdd, 0x01, 0xc7, 0x01, 0x10, 0x01, 0x00,
  0x01, 0x6c, 0x01, 0xdb, 0x01, 0x50, 0x07, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x10, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x10, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x10, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x10, 0x00, 0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x10, 0x00,
  0x01, 0x07, 0x01, 0xff, 0x01, 0xf3, 0x10, 0x00, 0x01, 0x07, 0x01, 0xff,
  0x01, 0xf3, 0x10, 0x00, 0x01, 0x07, 0x01, 0xee, 0x01, 0xe3, 0x35, 0x00,

  /* 39 PILCROW_SIGN */
  0x9c, 0x00, 0x01, 0x16, 0x01, 0x9b, 0x04, 0xcc, 0x01, 0xca, 0x0b, 0x00,
  0x01, 0x19, 0x06, 0xff, 0x01, 0xfd, 0x0a, 0x00, 0x01, 0x03, 0x01, 0xef,
  0x03, 0xff, 0x01, 0xfb, 0x01, 0xaa, 0x01, 0xaf, 0x01, 0xfd, 0x0a, 0x00,
  0x01, 0x2e, 0x04, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd,
  0x0a, 0x00, 0x01, 0xbf, 0x04, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f,
  0x01, 0xfd, 0x09, 0x00, 0x01, 0x03, 0x05, 0xff, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x09, 0x00, 0x01, 0x08, 0x05, 0xff, 0x01, 0xf2,
  0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd, 0x09, 0x00, 0x01, 0x0b, 0x05, 0xff,
  0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd, 0x09, 0x00, 0x01, 0x0c,
  0x05, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd, 0x09, 0x00,
  0x01, 0x0b, 0x05, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd,
  0x09, 0x00, 0x01, 0x0a, 0x05, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f,
  0x01, 0xfd, 0x09, 0x00, 0x01, 0x06, 0x05, 0xff, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0a, 0x00, 0x01, 0xef, 0x04, 0xff, 0x01, 0xf2,
  0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd, 0x0a, 0x00, 0x01, 0x6f, 0x04, 0xff,
  0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd, 0x0a, 0x00, 0x01, 0x08,
  0x04, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd, 0x0b, 0x00,
  0x01, 0x5e, 0x03, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f, 0x01, 0xfd,
  0x0c, 0x00, 0x01, 0x6b, 0x02, 0xff, 0x01, 0xf2, 0x01, 0x00, 0x01, 0x0f,
  0x01, 0xfd, 0x0d, 0x00, 0x01, 0x01, 0x01, 0xcf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0xbf, 0x01, 0xf2, 0x01, 0x00,
  0x01, 0x0f, 0x01, 0xfd, 0x0e, 0x00, 0x01, 0x34, 0x01, 0x40, 0x01, 0x00,
  0x01, 0x04, 0x01, 0x43, 0x7a, 0x00,

  /* 40 BROKEN_BAR */
  0xad, 0x00, 0x01, 0x07, 0x01, 0x99, 0x01, 0x60, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x08, 0x01, 0xbb, 0x01, 0x70, 0x6f, 0x00, 0x01, 0x0b,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0,
  0x10, 0x00, 0x01, 0x0c, 0x01, 0xff, 0x01, 0xa0, 0x10, 0x00, 0x01, 0x04,
  0x01, 0x55, 0x01, 0x30, 0x47, 0x00,

  /* 41 SECTION_SIGN */
  0x89, 0x00, 0x01, 0x35, 0x01, 0x64, 0x01, 0x31, 0x0e, 0x00, 0x01, 0x01,
  0x01, 0x9e, 0x03, 0xff, 0x01, 0xd9, 0x01, 0x30, 0x0c, 0x00, 0x01, 0x2e,
  0x05, 0xff, 0x01, 0xb0, 0x0c, 0x00, 0x01, 0xef, 0x01, 0xff, 0x01, 0xfb,
  0x01, 0x98, 0x01, 0xae, 0x01, 0xff, 0x01, 0xb0, 0x0b, 0x00, 0x01, 0x07,
  0x01, 0xff, 0x01, 0xfc, 0x01, 0x10, 0x02, 0x00, 0x01, 0x39, 0x01, 0xa0,
  0x0b, 0x00, 0x01, 0x0b, 0x01, 0xff, 0x01, 0xf2, 0x10, 0x00, 0x01, 0x0c,
  0x01, 0xff, 0x01, 0xf0, 0x10, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xf3,
  0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xfd, 0x01, 0x20, 0x10, 0x00,
  0x01, 0xdf, 0x01, 0xff, 0x01, 0xe4, 0x10, 0x00, 0x01, 0x1d, 0x02, 0xff,
  0x01, 0xa1, 0x0f, 0x00, 0x01, 0x4e, 0x03, 0xff, 0x01, 0x70, 0x0d, 0x00,
  0x01, 0x06, 0x01, 0xff, 0x01, 0xf9, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xfd,
  0x01, 0x30, 0x0c, 0x00, 0x01, 0x3f, 0x01, 0xff, 0x01, 0x60, 0x01, 0x07,
  0x02, 0xff, 0x01, 0xf8, 0x0c, 0x00, 0x01, 0xbf, 0x01, 0xf9, 0x02, 0x00,
  0x01, 0x19, 0x02, 0xff, 0x01, 0xc0, 0x0b, 0x00, 0x01, 0xff, 0x01, 0xf3,
  0x03, 0x00, 0x01, 0x4e, 0x01, 0xff, 0x01, 0xfb, 0x0a, 0x00, 0x01, 0x01,
  0x01, 0xff, 0x01, 0xf2, 0x03, 0x00, 0x01, 0x01, 0x01, 0xdf, 0x01, 0xff,
  0x01, 0x40, 0x09, 0x00, 0x01, 0x01, 0x01, 0xff, 0x01, 0xf7, 0x04, 0x00,
  0x01, 0x2f, 0x01, 0xff, 0x01, 0x90, 0x0a, 0x00, 0x01, 0xdf, 0x01, 0xff,
  0x01, 0x20, 0x03, 0x00, 0x01, 0x0a, 0x01, 0xff, 0x01, 0xb0, 0x0a, 0x00,
  0x01, 0x6f, 0x01, 0xff, 0x01, 0xf5, 0x03, 0x00, 0x01, 0x08, 0x01, 0xff,
  0x01, 0xa0, 0x0a, 0x00, 0x01, 0x0a, 0x02, 0xff, 0x01, 0x91, 0x02, 0x00,
  0x01, 0x0c, 0x01, 0xff, 0x01, 0x70, 0x0b, 0x00, 0x01, 0x8f, 0x01, 0xff,
  0x01, 0xfe, 0x01, 0x60, 0x01, 0x00, 0x01, 0x6f, 0x01, 0xff, 0x01, 0x10,
  0x0b, 0x00, 0x01, 0x03, 0x01, 0xdf, 0x01, 0xff, 0x01, 0xfd, 0x01, 0x46,
  0x01, 0xff, 0x01, 0xf5, 0x0d, 0x00, 0x01, 0x07, 0x04, 0xff, 0x01, 0x50,
  0x0e, 0x00, 0x01, 0x2a, 0x02, 0xff, 0x01, 0xf5, 0x10, 0x00, 0x01, 0x4e,
  0x01, 0xff, 0x01, 0xfe, 0x01, 0x20, 0x0f, 0x00, 0x01, 0x01, 0x01, 0xcf,
  0x01, 0xff, 0x01, 0xc0, 0x10, 0x00, 0x01, 0x1e, 0x01, 0xff, 0x01, 0xf3,
  0x10, 0x00, 0x01, 0x06, 0x01, 0xff, 0x01, 0xf6, 0x10, 0x00, 0x01, 0x05,
  0x01, 0xff, 0x01, 0xf6, 0x0b, 0x00, 0x01, 0x01, 0x04, 0x00, 0x01, 0x0a,
  0x01, 0xff, 0x01, 0xf3, 0x0b, 0x00, 0x01, 0x08, 0x01, 0xe8, 0x01, 0x20,
  0x01, 0x00, 0x01, 0x01, 0x01, 0x8f, 0x01, 0xff, 0x01, 0xe0, 0x0b, 0x00,
  0x01, 0x08, 0x01, 0xff, 0x01, 0xfe, 0x01, 0xcb, 0x01, 0xdf, 0x02, 0xff,
  0x01, 0x40, 0x0b, 0x00, 0x01, 0x08, 0x05, 0xff, 0x01, 0xf5, 0x0d, 0x00,
  0x01, 0x49, 0x01, 0xdf, 0x02, 0xff, 0x01, 0xe8, 0x01, 0x20, 0x0f, 0x00,
  0x01, 0x12, 0x01, 0x21, 0x7f, 0x00,

  /* 42 NOT_SIGN */
  0xff, 0x00, 0x7f, 0x00, 0x01, 0x12, 0x0c, 0x22, 0x06, 0x00, 0x01, 0x9f,
  0x0c, 0xff, 0x01, 0x40, 0x05, 0x00, 0x01, 0x9f, 0x0c, 0xff, 0x01, 0x40,
  0x05, 0x00, 0x01, 0x9f, 0x0c, 0xff, 0x01, 0x40, 0x05, 0x00, 0x01, 0x24,
  0x0a, 0x44, 0x01, 0x6f, 0x01, 0xff, 0x01, 0x40, 0x10, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0x40, 0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x40,
  0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x40, 0x10, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0x40, 0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x40,
  0x10, 0x00, 0x01, 0x2f, 0x01, 0xff, 0x01, 0x40, 0x10, 0x00, 0x01, 0x2f,
  0x01, 0xff, 0x01, 0x40, 0x10, 0x00, 0x01, 0x17, 0x01, 0x77, 0x01, 0x10,
  0xff, 0x00, 0x34, 0x00
#endif // TOUCH_UI_UTF8_SYMBOLS
};
